package io.gamedock.sdk.models.userdata.inventory;

import com.google.gson.Gson;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import io.gamedock.sdk.userdata.playerdata.PlayerDataManager;

public class Inventory {

    private ConcurrentHashMap<Integer, PlayerItem> itemsMap = new ConcurrentHashMap<>();
    private ArrayList<PlayerItem> items = new ArrayList<>();

    private ConcurrentHashMap<String, UniquePlayerItem> uniqueItemsMap = new ConcurrentHashMap<>();
    private ArrayList<UniquePlayerItem> uniqueItems = new ArrayList<>();

    private long offset;
    private String logic;

    public ConcurrentHashMap<Integer, PlayerItem> getItemsMap() {
        return itemsMap;
    }

    public void setItemsMap(ConcurrentHashMap<Integer, PlayerItem> itemsMap) {
        this.itemsMap = itemsMap;
    }

    public ArrayList<PlayerItem> getItems() {
        return items;
    }

    public void setItems(ArrayList<PlayerItem> items) {
        this.items = items;
    }

    public ConcurrentHashMap<String, UniquePlayerItem> getUniqueItemsMap() {
        return uniqueItemsMap;
    }

    public void setUniqueItemsMap(ConcurrentHashMap<String, UniquePlayerItem> uniqueItemsMap) {
        this.uniqueItemsMap = uniqueItemsMap;
    }

    public ArrayList<UniquePlayerItem> getUniqueItems() {
        return uniqueItems;
    }

    public void setUniqueItems(ArrayList<UniquePlayerItem> uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public long getOffset() {
        return offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getLogic() {
        return logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public void updateItem(PlayerItem item) {
        itemsMap.get(item.getId()).setAmount(item.getAmount());
        itemsMap.get(item.getId()).setDelta(item.getDelta());
    }

    public ArrayList<PlayerItem> getGachas() {
        ArrayList<PlayerItem> gachas = new ArrayList<>();

        for (PlayerItem playerItem : getItems()) {
            if (playerItem.isGacha()) {
                gachas.add(playerItem);
            }
        }

        return gachas;
    }

    public Inventory BuildForJson() {
        Inventory data = new Inventory();

        for (PlayerItem item : itemsMap.values()) {
            if (!(item.getAmount() == 0 && item.getDelta() == 0)) {
                data.items.add(item);
            }
        }

        data.uniqueItems.addAll(uniqueItemsMap.values());

        data.setOffset(offset);
        data.setLogic(logic);

        return data;
    }

    public JSONObject toJson(Gson gson) {
        JSONObject inventoryJSON = null;
        try {
            inventoryJSON = new JSONObject(gson.toJson(this));
            inventoryJSON.remove(PlayerDataManager.ItemsMap);
            inventoryJSON.remove(PlayerDataManager.UniqueItemsMap);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return inventoryJSON;
    }

    public Inventory clone() {
        Inventory clone = new Inventory();

        if (itemsMap != null) {
            for (Map.Entry<Integer, PlayerItem> entry : itemsMap.entrySet()) {
                clone.getItemsMap().put(entry.getKey(), entry.getValue().clone());
            }
        }

        if (uniqueItemsMap != null) {
            for (Map.Entry<String, UniquePlayerItem> entry : uniqueItemsMap.entrySet()) {
                clone.getUniqueItemsMap().put(entry.getKey(), entry.getValue().clone());
            }
        }

        if (items != null) {
            for (PlayerItem playerItem : items) {
                clone.getItems().add(playerItem.clone());
            }
        }

        if (uniqueItems != null) {
            for (UniquePlayerItem uniquePlayerItem : uniqueItems) {
                clone.getUniqueItems().add(uniquePlayerItem.clone());
            }
        }

        clone.setOffset(offset);
        clone.setLogic(logic);

        return clone;
    }
}
