package io.gamedock.sdk.models.gamedata.promotion;

import java.util.ArrayList;
import java.util.Calendar;

public class Promotion {

    private int id;
    private String name;
    private int amountPurchased;
    private int maxPurchase;
    private String label;
    private long startDate;
    private long endDate;
    private ArrayList<AffectedEntity> affectedEntities = new ArrayList<>();
    private ArrayList<ExtraEntity> extraEntities = new ArrayList<>();
    private ArrayList<PriceOverride> priceOverride = new ArrayList<>();
    private ArrayList<GameAsset> gameAssets = new ArrayList<>();
    private boolean hasSplashscreen;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAmountPurchased() {
        return amountPurchased;
    }

    public void setAmountPurchased(int amountPurchased) {
        this.amountPurchased = amountPurchased;
    }

    public int getMaxPurchase() {
        return maxPurchase;
    }

    public void setMaxPurchase(int maxPurchase) {
        this.maxPurchase = maxPurchase;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public long getStartDate() {
        return startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public long getEndDate() {
        return endDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public ArrayList<AffectedEntity> getAffectedEntities() {
        return affectedEntities;
    }

    public void setAffectedEntities(ArrayList<AffectedEntity> affectedEntities) {
        this.affectedEntities = affectedEntities;
    }

    public ArrayList<ExtraEntity> getExtraEntities() {
        return extraEntities;
    }

    public void setExtraEntities(ArrayList<ExtraEntity> extraEntities) {
        this.extraEntities = extraEntities;
    }

    public ArrayList<PriceOverride> getPriceOverride() {
        return priceOverride;
    }

    public void setPriceOverride(ArrayList<PriceOverride> priceOverride) {
        this.priceOverride = priceOverride;
    }

    public ArrayList<GameAsset> getGameAssets() {
        return gameAssets;
    }

    public void setGameAssets(ArrayList<GameAsset> gameAssets) {
        this.gameAssets = gameAssets;
    }

    public boolean isHasSplashscreen() {
        return hasSplashscreen;
    }

    public void setHasSplashscreen(boolean hasSplashscreen) {
        this.hasSplashscreen = hasSplashscreen;
    }

    public boolean isValid() {
        return endDate > Calendar.getInstance().getTimeInMillis() && (amountPurchased < maxPurchase || maxPurchase == 0);
    }
}
