package io.gamedock.sdk.models.gamedata.perk;

import java.util.ArrayList;

public class PerkItem {
    public String name;
    public ArrayList<PerkPriceReduction> priceReductions = new ArrayList<>();
    public ArrayList<PerkAddition> additions = new ArrayList<>();
    public ArrayList<PerkGachaWeight> gachaWeights = new ArrayList<>();

    public PerkItem clone() {
        PerkItem newClone = new PerkItem();
        newClone.name = name;

        ArrayList<PerkPriceReduction> clonedPriceReductions = new ArrayList<>();
        for(PerkPriceReduction perkPriceReduction : priceReductions) {
            clonedPriceReductions.add(perkPriceReduction.clone());
        }
        newClone.priceReductions = clonedPriceReductions;

        ArrayList<PerkAddition> clonedAdditions = new ArrayList<>();
        for(PerkAddition clonedAddition : additions) {
            clonedAdditions.add(clonedAddition.clone());
        }
        newClone.additions = clonedAdditions;

        ArrayList<PerkGachaWeight> clonedGachaWeights = new ArrayList<>();
        for(PerkGachaWeight clonedWeight : gachaWeights) {
            clonedGachaWeights.add(clonedWeight.clone());
        }
        newClone.gachaWeights = clonedGachaWeights;

        return newClone;
    }
}
