package io.gamedock.sdk.models.ads.admob;

import java.util.ArrayList;
import java.util.Map;

import io.gamedock.sdk.models.ads.internal.PriorityAdConfig;

/**
 * Object class that holds the information for a AdMob Event
 * It can either contain initialisation information or show ad logic
 */
public class AdMobObject {

    public String appId;
    public String bannerAdUnitId;
    public String interstitialAdUnitId;
    public String rewardVideoAdUnitId;
    public String adType;
    public Map<String, String> interstitialCustomTargeting;
    public Map<String, String> rewardVideoCustomTargeting;
    public AdMobMediationNetworks adMobMediationNetworks;
    public ArrayList<PriorityAdConfig> priorityAdConfigs = new ArrayList<>();
    public int conditionId;

    public AdMobObject(String appId, String bannerAdUnitId, String interstitialAdUnitId, String rewardVideoAdUnitId, String adType, int conditionId, Map<String, String> interstitialCustomTargeting, Map<String, String> rewardVideoCustomTargeting, AdMobMediationNetworks adMobMediationNetworks, ArrayList<PriorityAdConfig> priorityAdConfigs) {
        this.appId = appId;
        this.bannerAdUnitId = bannerAdUnitId;
        this.interstitialAdUnitId = interstitialAdUnitId;
        this.rewardVideoAdUnitId = rewardVideoAdUnitId;
        this.adType = adType;
        this.conditionId = conditionId;
        this.interstitialCustomTargeting = interstitialCustomTargeting;
        this.rewardVideoCustomTargeting = rewardVideoCustomTargeting;
        this.adMobMediationNetworks = adMobMediationNetworks;
        this.priorityAdConfigs = priorityAdConfigs;
    }

}
