package io.gamedock.sdk.google.dynamiclinks;

import android.net.Uri;

import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that handles the Reward Callbacks.
 * Notifies the application when the Reward has been received and processed by the SDK.
 */
public class DeepLinkCallbacks {

    private OnDeepLinkListener deepLinkListener;

    public DeepLinkCallbacks() {
        deepLinkListener = null;
    }

    public DeepLinkCallbacks(OnDeepLinkListener rewardListener) {
        this.deepLinkListener = rewardListener;
    }

    /**
     * Method that is called when a deep link has been received and needs to be sent to Native/Unity.
     *
     * @param url      The deeplink url.
     */
    public void deepLinkReceived(String url) {

        Uri uri = Uri.parse(url);

        String payload = uri.getQueryParameter("payload");
        JSONObject payloadJson = null;
        if(payload != null) {
            try {
                payload = URLDecoder.decode(payload, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            try {
                payloadJson = new JSONObject(payload);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("url", url);
            jsonObject.put("payload", payloadJson);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (deepLinkListener != null) {
            deepLinkListener.onDeepLinkReceived(url, payloadJson);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "DeepLinkReceived", jsonObject.toString());
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }
}