package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding the server time response.
 */
public class ServerDataResponseEvent extends ResponseEvent {

    private long serverTime;

    ServerDataResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                if (responseEvent.responseData.has("serverTime")) {
                    serverTime = responseEvent.responseData.getLong("serverTime");
                }
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for ServerDataResponseEvent");

        if (getAction().toLowerCase().trim().equals("servertime")) {
            GamedockSDK.getInstance(context).getServerDataCallbacks().serverTimeRequestSuccess(serverTime);
        }
    }
}
