package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.pushnotifications.NotificationManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding notification data responses.
 */
public class NotificationResponseEvent extends ResponseEvent {

    NotificationResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for NotificationResponseEvent");

        if (getAction().toLowerCase().trim().equals("show")) {
            NotificationManager.processNotificationForShowing(context, responseData);
        } else if (getAction().toLowerCase().trim().equals("hidden")) {
            NotificationManager.processNotificationForHidden(context, responseData);
        }
    }
}
