package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.userdata.UserDataManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding mission data responses.
 */
public class MissionDataResponseEvent extends ResponseEvent {

    MissionDataResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            setMessage(responseEvent.getMessage());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for MissionDataResponseEvent");

        String action = getAction().toLowerCase().trim();

        switch (action) {
            case "syncerror":
                UserDataManager.getInstance(context).processSyncError();
                break;
            case "dropped":
                UserDataManager.getInstance(context).processDroppedResponse(getMessage());
                break;
            case "lockerror":
                UserDataManager.getInstance(context).processLockError();
                break;
        }
    }
}
