package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.utils.IAP.IAPUtil;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding IAP purchase responses.
 */
public class IAPResponseEvent extends ResponseEvent {

    private String iapJSON;

    IAPResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                this.iapJSON = responseEvent.responseData.toString();
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for IAPResponseEvent");

        if (getAction().toLowerCase().trim().equals("validate")) {
            IAPUtil.processValidateIAP(context, iapJSON);
        }
    }
}
