package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class    RewardEvent extends Event {

    public static final String ClaimTokenEvent = "claimToken";
    private String rewardType;

    public RewardEvent(Context context) {
        super(context);
    }

    public void setClaimTokenEvent() {
        this.setName(ClaimTokenEvent);
    }

    public void setRewardType(String rewardType) {
        this.rewardType = rewardType;
        this.addCustomData("rewardType", rewardType);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        GamedockSDK.getInstance(context).getRewardCallbacks().rewardTokenClaimFailed(rewardType, ErrorCodes.RewardServerError);
        setNetworkErrorHandled(true);
    }
}
