package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.localization.LocalizationManager;
import io.gamedock.sdk.utils.device.NetworkUtil;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class LocalizationEvent extends Event {
    public static final String RequestLocalization = "requestLocalization";
    public static final String LocalizationKeyNotFound = "localizationKeyNotFound";

    public LocalizationEvent(Context context) {
        super(context);
    }

    public void setRequestLocalization() {
        this.setName(RequestLocalization);
    }

    public void setLocalizationKeyNotFound() {
        this.setName(LocalizationKeyNotFound);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if (getName().equals(RequestLocalization)) {
            if (NetworkUtil.isInternetAvailable(context)) {
                GamedockSDK.getInstance(context).getLocalizationCallbacks().localizationError(ErrorCodes.LocalizationError);
            } else {
                String locale = getCustomDataAsString("locale");
                if (LocalizationManager.getInstance(context).localizationData != null && LocalizationManager.getInstance(context).localizationData.getLocale().equals(locale)) {
                    GamedockSDK.getInstance(context).getLocalizationCallbacks().localizationAvailable(locale, false);
                } else if (LocalizationManager.getInstance(context).defaultLocalizationData != null && LocalizationManager.getInstance(context).fallbackToDefaultLocale) {
                    GamedockSDK.getInstance(context).getLocalizationCallbacks().localizationAvailable(LocalizationManager.getInstance(context).defaultLocalizationData.getLocale(), true);
                } else {
                    GamedockSDK.getInstance(context).getLocalizationCallbacks().localizationNotAvailable();
                }
            }

        }

        setNetworkErrorHandled(true);
    }
}
