package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class IAPEvent extends Event {

    private static final String IAPPurchasedEvent = "iapPurchased";
    public static final String ValidateSubscription = "validateSubscription";

    public IAPEvent(Context context) {
        super(context);
    }

    public void setIAPPurchasedEvent() {
        this.setName(IAPPurchasedEvent);
    }

    public void setValidateSubscription() {
        this.setName(ValidateSubscription);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        GamedockSDK.getInstance(context).getIapCallbacks().iapServerError(ErrorCodes.IAPServerError);
        setNetworkErrorHandled(true);
    }
}
