package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.assetbundles.AssetBundlesManager;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.device.NetworkUtil;

public class AssetBundlesEvent extends Event{

    public static final String RequestAssetBundles = "requestAssetBundles";

    public AssetBundlesEvent(Context context) {
        super(context);
    }

    public void setRequestAssetBundles() {
        this.setName(RequestAssetBundles);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if(NetworkUtil.isInternetAvailable(context)) {
            GamedockSDK.getInstance(context).getAssetBundlesCallbacks().assetBundlesNotAvailable();
        } else {
            if(!AssetBundlesManager.getInstance(context).getAssetBundles().isEmpty()) {
                GamedockSDK.getInstance(context).getAssetBundlesCallbacks().assetBundlesAvailable(GamedockSDK.getInstance(context).getAssetBundles());
            } else {
                GamedockSDK.getInstance(context).getAssetBundlesCallbacks().assetBundlesNotAvailable();
            }
        }

        setNetworkErrorHandled(true);
    }

}
