package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;


public class AdvertisementEvent extends Event {

    public static final String AdvertisementInit = "advertisementInit";
    public static final String RequestRewardVideo = "requestRewardVideo";
    public static final String RequestInterstitial = "requestInterstitial";

    public AdvertisementEvent(Context context) {
        super(context);
    }

    public void setRequestAdvertisementInit() {
        this.setName(AdvertisementInit);
    }

    public void setRequestRewardVideo() {
        this.setName(RequestRewardVideo);
    }

    public void setRequestInterstitial() {
        this.setName(RequestInterstitial);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (getName().equals(RequestRewardVideo) && !isNetworkErrorHandled()) {
            GamedockSDK.getInstance(context).getAdCallbacks().AdNotAvailable("rewardVideo");
            setNetworkErrorHandled(true);
        } else if (getName().equals(RequestInterstitial) && !isNetworkErrorHandled()) {
            GamedockSDK.getInstance(context).getAdCallbacks().AdNotAvailable("interstitial");
            setNetworkErrorHandled(true);
        }
    }
}
