package io.gamedock.sdk.ads.internal;

import android.content.Context;
import android.content.Intent;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.internal.MoreAppsEvent;
import io.gamedock.sdk.models.ads.internal.GamedockMoreAppsObject;
import io.gamedock.sdk.utils.features.FeaturesUtil;
import io.gamedock.sdk.web.WebViewActivity;

/**
 * Class that handles the Spil More Apps logic.
 * Sends the different status that the ads going through: Available, Not Available, Started, Finished.
 * Handles the logic to create a circular progress bar before showing an ad.
 */
public class GamedockMoreAppsManager {
    private static final Object lock = new Object();
    private static volatile GamedockMoreAppsManager mInstance;

    public static final String FEATURE_NAME = "moreApps";

    public GamedockMoreAppsObject gamedockMoreAppsObject;
    public boolean isMoreAppsEnabled;

    public static GamedockMoreAppsManager getInstance() {
        if (mInstance == null) {
            synchronized (lock) {
                if (mInstance == null) {
                    mInstance = new GamedockMoreAppsManager();
                }
            }
        }
        return mInstance;
    }

    /**
     * Method called to request the more apps configuration from Gamedock backend.
     *
     * @param context The Activity context.
     */
    public void requestGamedockMoreApps(Context context) {
        if (!FeaturesUtil.isFeatureEnabled(FEATURE_NAME)) {
            return;
        }

        MoreAppsEvent rewardEvent = new MoreAppsEvent(context);
        rewardEvent.setRequestMoreApps();

        GamedockSDK.getInstance(context).trackEvent(rewardEvent, null);
    }

    /**
     * Method used to process the response for more apps from Gamedock backend and notify the game if there is a screen available or not.
     *
     * @param context            The Activity context.
     * @param gamedockMoreAppsObject The Gamedock backend more apps configuration used to open and display the more apps screen.
     */
    public void processSpilMoreApps(Context context, GamedockMoreAppsObject gamedockMoreAppsObject) {
        if (gamedockMoreAppsObject.url == null || gamedockMoreAppsObject.url.equals("")) {
            GamedockSDK.getInstance(context).getAdCallbacks().AdNotAvailable("moreApps");
            return;
        }

        this.gamedockMoreAppsObject = gamedockMoreAppsObject;
        isMoreAppsEnabled = true;

        GamedockSDK.getInstance(context).getAdCallbacks().AdAvailable("moreApps");
    }

    /**
     * Method used to display the more apps screen.
     * Uses the {@link GamedockMoreAppsObject} received from Gamedock backend.
     *
     * @param context The Activity context.
     */
    public void showGamedockMoreApps(Context context) {
        if (!FeaturesUtil.isFeatureEnabled(FEATURE_NAME)) {
            GamedockSDK.getInstance(context).getAdCallbacks().AdNotAvailable("moreApps");
            return;
        }

        if (gamedockMoreAppsObject == null) {
            GamedockSDK.getInstance(context).getAdCallbacks().AdNotAvailable("moreApps");
            return;
        }

        try {
            GamedockSDK.getInstance(context).isShowingChildActivity = true;

            Intent intent = new Intent(context, WebViewActivity.class);
            intent.putExtra("webViewUrl", gamedockMoreAppsObject.url);
            intent.putExtra("eventName", "moreApps");
            intent.putExtra("eventData", gamedockMoreAppsObject.data.toString());
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

}
