package io.gamedock.sdk.ads.internal;

import android.app.ActionBar;
import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;

import com.lusfold.spinnerloading.SpinnerLoading;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.ads.AdEvents;
import io.gamedock.sdk.ads.AdManager;
import io.gamedock.sdk.ads.admob.AdMobManager;
import io.gamedock.sdk.ads.core.interstitial.InterstitialAd;
import io.gamedock.sdk.ads.core.rewarded.RewardedVideoAd;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Activity used as a container for displaying AdMob interstitials or Reward Videos.
 * Shows a spinner during loading of the interstitial.
 */
public class GamedockAdsAdActivity extends Activity {

    public static Activity activity;
    private Button cancelButton;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable runnable;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        View decorView = getWindow().getDecorView();
        // Hide the status bar.
        int uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_FULLSCREEN
                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        decorView.setSystemUiVisibility(uiOptions);
        // Remember that you should never show the action bar if the
        // status bar is hidden, so hide that too if necessary.
        ActionBar actionBar = getActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }

        RelativeLayout layout = new RelativeLayout(this);
        layout.setBackgroundColor(Color.TRANSPARENT);
        layout.setPadding(0, 0, 0, 0);

        activity = this;

        RelativeLayout relativeLayout = new RelativeLayout(this);
        relativeLayout.setBackgroundColor(0xB3000000);
        RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);

        rlp.setMargins(0, 0, 0, 0);

        Bundle extras = getIntent().getExtras();

        if (extras != null) {
            final String adType = extras.getString("adType", null);

            if (adType == null) {
                finish();
                return;
            }

            SpinnerLoading spinnerLoading = AdManager.getInstance().showAdvanceSpinner(this);

            if (spinnerLoading != null) {
                relativeLayout.addView(spinnerLoading);
            } else {
                relativeLayout.addView(AdManager.getInstance().showBasicSpinner(this));
            }

            RelativeLayout.LayoutParams cancelButtonParams = new RelativeLayout.LayoutParams(500, 120);
            cancelButtonParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            cancelButtonParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
            cancelButtonParams.bottomMargin = 48;

            cancelButton = new Button(this);
            cancelButton.setText("Cancel ad");
            cancelButton.setTextColor(Color.WHITE);
            cancelButton.setBackgroundColor(0xff33A7ff);

            cancelButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    LoggingUtil.d("Canceled playing ad by user.");
                    if (adType.equals(AdManager.REWARD_VIDEO)) {
                        AdEvents.rewardVideoDidNotDisplay(activity);
                        if (AdMobManager.getInstance().getSelectedRewardVideoPriorityConfig() != null) {
                            AdMobManager.getInstance().getSelectedRewardVideoPriorityConfig().setHasFill(false);
                        }
                        GamedockSDK.getInstance(activity).getAdCallbacks().AdFinished(AdManager.GamedockAds, AdManager.REWARD_VIDEO, "dismiss");
                    } else if (adType.equals(AdManager.INTERSTITIAL)) {
                        AdEvents.interstitialDidNotDisplay(activity, GamedockAdsManager.getInstance().getGamedockAdsInterstitial().getConditionId());
                        if (AdMobManager.getInstance().getSelectedInterstitialPriorityConfig() != null) {
                            AdMobManager.getInstance().getSelectedInterstitialPriorityConfig().setHasFill(false);
                        }
                        GamedockSDK.getInstance(activity).getAdCallbacks().AdFinished(AdManager.GamedockAds, AdManager.INTERSTITIAL, "close");
                    }
                    if (activity != null) {
                        activity.finish();
                    }
                }
            });

            runnable = new Runnable() {
                @Override
                public void run() {
                    if (activity != null && cancelButton != null) {
                        cancelButton.setVisibility(View.VISIBLE);
                    }
                }
            };

            scheduleCancelButton(5000);

            relativeLayout.addView(cancelButton, cancelButtonParams);

            setContentView(relativeLayout, rlp);
            String adProvider = extras.getString("adProvider", null);
            if (adType.equals(AdManager.INTERSTITIAL)) {
                if (adProvider == null) {
                    activity.finish();
                    return;
                }

                if (adProvider.equals(AdManager.GamedockAds)) {
                    displayGamedockAdsInterstitial();
                } else {
                    activity.finish();
                }
            } else if (adType.equals(AdManager.REWARD_VIDEO)) {
                if (adProvider == null) {
                    activity.finish();
                    return;
                }

                if (adProvider.equals(AdManager.GamedockAds)) {
                    displayGamedockAdsRewardVideo();
                } else {
                    activity.finish();
                }
            }
        }
    }

    private void displayGamedockAdsInterstitial() {
        InterstitialAd interstitialAdView = GamedockAdsManager.getInstance().getGamedockAdsInterstitial().getInterstitialAd();

        if (interstitialAdView == null) {
            LoggingUtil.d("Could not play Gamedock Ads interstitial, interstitialAdView was null");
            AdEvents.interstitialDidNotDisplay(this, GamedockAdsManager.getInstance().getGamedockAdsInterstitial().getConditionId());
            if (AdMobManager.getInstance().getSelectedInterstitialPriorityConfig() != null) {
                AdMobManager.getInstance().getSelectedInterstitialPriorityConfig().setHasFill(false);
            }
            activity.finish();
            return;
        }

        if (interstitialAdView.isLoaded()) {
            scheduleCancelButton(40000);
            LoggingUtil.d("Displaying Gamedock Ads Interstitial");
            interstitialAdView.show();
        } else {
            LoggingUtil.d("Could not play Gamedock Ads interstitial, interstitialAdView was not loaded");
            AdEvents.interstitialDidNotDisplay(this, GamedockAdsManager.getInstance().getGamedockAdsInterstitial().getConditionId());
            if (AdMobManager.getInstance().getSelectedInterstitialPriorityConfig() != null) {
                AdMobManager.getInstance().getSelectedInterstitialPriorityConfig().setHasFill(false);
            }
            activity.finish();
        }
    }

    private void displayGamedockAdsRewardVideo() {
        RewardedVideoAd rewardedVideoAdView = GamedockAdsManager.getInstance().getGamedockAdsRewardedVideo().getRewardedVideoAd();

        if (rewardedVideoAdView == null) {
            LoggingUtil.d("Could not play Gamedock Ads reward video, rewardedVideoAdView was null");
            AdEvents.rewardVideoDidNotDisplay(this);
            if (AdMobManager.getInstance().getSelectedRewardVideoPriorityConfig() != null) {
                AdMobManager.getInstance().getSelectedRewardVideoPriorityConfig().setHasFill(false);
            }
            activity.finish();
            return;
        }

        if (rewardedVideoAdView.isLoaded()) {
            scheduleCancelButton(40000);
            LoggingUtil.d("Displaying Gamedock Ads Reward Video");
            rewardedVideoAdView.show();
        } else {
            LoggingUtil.d("Could not play Gamedock Ads reward video, rewardedVideoAdView was not loaded");
            AdEvents.rewardVideoDidNotDisplay(this);
            if (AdMobManager.getInstance().getSelectedRewardVideoPriorityConfig() != null) {
                AdMobManager.getInstance().getSelectedRewardVideoPriorityConfig().setHasFill(false);
            }
            activity.finish();
        }
    }

    private void scheduleCancelButton(long delay) {
        handler.removeCallbacks(runnable);
        cancelButton.setVisibility(View.INVISIBLE);
        handler.postDelayed(runnable, delay);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        LoggingUtil.d("Closing Gamedock Ads Activity");
        AdManager.getInstance().isFullScreenAdShowing = false;
        GamedockSDK.getInstance(this).isShowingChildActivity = false;
        activity = null;
    }
}
