package io.gamedock.sdk.activities.interfaces;

/**
 * Interface used by the Unity Activities.
 * Describes all the methods that are exposed from the Native SDK to the Unity Plugin.
 */

public interface GamedockActivityInterface {

    void init(boolean withPrivacyPolicy, boolean coppaEnabled);

    void init(boolean withPrivacyPolicy, boolean coppaEnabled, String externalIds);

    void resetData();

    void checkAgeGate(boolean shouldBlock, int requiredAged);

    void checkPrivacyPolicy();

    void showPrivacyPolicySettings();

    void savePrivValue(int priv);

    String getPrivValue();

    void trackEvent(String eventName, String parameters);

    void confirmUserIdChange();

    void enableNotifications();

    void disableNotification();

    void registerDevice(String store);

    void requestGameConfig();

    String getConfigAll(boolean withSdkConfig);

    String getConfigValue(String key);

    void validateSubscription(String skuId, String transactionId, String token);

    String getAllPackages();

    String getPackage(String packageId);

    String getGamedockUserId();

    void setPluginInformation(String pluginName, String pluginVersion);

    void clearLog();

    String getLog();

    String getFeatureVersionId(String feature);

    void startAdMob(String adUnitId, String type);

    void requestAd(String provider, String adType, boolean parentalGate);

    void requestRewardVideo(String location, String rewardType);

    void playVideo(String location, String rewardType);

    void requestInterstitial();

    void showInterstitial(String provider);

    void requestMoreApps();

    void playMoreApps();

    void requestBannerAd(String position, String adSize);

    void showBannerAd();

    void hideBannerAd();

    String isAdAvailable(String adType);

    void setAdTestDevice(String deviceId);

    String getWallet();

    String getInventory();

    void processUserDataTransactions(String transactions, String reason, String location, String reasonDetails, String transactionId, String callbackId);

    String getGamedockGameData();

    String getContainersConfiguration();

    String getMissionsConfiguration();

    void requestPromotions();

    String getAllPromotions();

    String getBundlePromotion(int bundleId);

    String getPackagePromotion(String packageId);

    void showPromotionScreen(int promotionId);

    void addCurrencyToWallet(int currencyId, int delta, String reason, String location, String reasonDetails, String transactionId, String callbackId);

    void subtractCurrencyFromWallet(int currencyId, int delta, String reason, String location, String reasonDetails, String transactionId, String callbackId);

    void addItemToInventory(int itemId, int amount, String reason, String location, String reasonDetails, String transactionId, String callbackId);

    void subtractItemFromInventory(int itemId, int amount, String reason, String location, String reasonDetails, String transactionId, String callbackId);

    String createUniqueItem(int itemId, String uniqueId);

    void addUniqueItemToInventory(String uniquePlayerItem, String reason, String reasonDetails, String location, String transactionId, String callbackId);

    void updateUniqueItemFromInventory(String uniquePlayerItem, String reason, String reasonDetails, String location, String transactionId, String callbackId);

    void removeUniqueItemFromInventory(String uniquePlayerItem, String reason, String reasonDetails, String location, String transactionId, String callbackId);

    void buyBundle(int bundleId, String reason, String location, String reasonDetails, String transactionId, String perkItems, String callbackId);

    void openGacha(int gachaId, String reason, String reasonDetails, String location, String perkItems, String callbackId);

    void setCurrencyLimit(int currencyId, int limit);

    void setItemLimit(int itemId, int limit);

    String getUserAllContainerProgress();

    String getUserAllMissionProgress();

    void updateContainerAndMissionProgress(String containerProgressList, String missionProgressList, String reason, String reasonDetails, String location, String transactionId);

    void updateContainerProgress(String containerProgressList, String reason, String reasonDetails, String location, String transactionId);

    void updateMissionProgress(String missionProgressList, String reason, String reasonDetails, String location, String transactionId);

    void claimContainersReward(String containerProgressList, String reason, String reasonDetails, String location, String transactionId);

    void claimMissionsReward(String missionProgressList, String reason, String reasonDetails, String location, String transactionId);

    String getImagePath(String url);

    void requestImage(String url, int id, String imageType);

    void clearDiskCache();

    void preloadItemAndBundleImages();

    void resetWallet();

    void resetInventory();

    void resetPlayerData();

    void resetMissionData();

    void updatePlayerData();

    void showZendeskWebViewHelpCenter(String url, String tags);

    void setUserId(String provider, String userId);

    String getUserId();

    String getUserProvider();

    void requestUserData();

    void setPrivateGameState(String gameState);

    String getPrivateGameState();

    void setPublicGameState(String gameState);

    String getPublicGameState();

    void getOtherUsersGameState(String provider, String userIdsList);

    void mergeUserData(String mergeData, String mergeType);

    void showMergeConflictDialog(String title, String message, String localButton, String remoteButton, String mergeButton);

    void showSyncErrorDialog(String title, String message, String mergeButton);

    void showMergeFailedDialog(String title, String message, String retryButton, String mergeData, String mergeType);

    void requestDailyBonus();

    void showDailyBonus();

    String getDailyBonusConfig();

    void collectDailyBonus();

    void requestSplashScreen(String type);

    void showSplashScreen();

    void claimToken(String token, String rewardType);

    void requestServerTime();

    void requestDangerousPermission(String permission, String rationale, String denyRationale);

    void requestTieredEvents();

    String getAllTieredEvents();

    String getTieredEventProgress(int tieredEventId);

    void showTieredEventProgress(int tieredEventId);

    void claimTierReward(int tieredEventId, int tierId);

    void userLogin(String socialId, String socialProvider, String socialToken, String socialValidationData);

    void userLogout(boolean global);

    void userPlayAsGuest();

    void showUnauthorizedDialog(String title, String message, String loginText, String playAsGuestText);

    String isLoggedIn();

    String getDeviceId();

    void showNativeDialog(String title, String message, String buttonText);

    void requestAssetBundles();

    String getAssetBundles();

    void requestFirebaseRemoteConfig(long cacheExpiration);

    void setFirebaseRemoteConfigDefaults(String defaultValues);

    String getBooleanFirebaseRemoteConfig(String key, String namespace);

    String getDoubleFirebaseRemoteConfig(String key, String namespace);

    String getLongFirebaseRemoteConfig(String key, String namespace);

    String getStringFirebaseRemoteConfig(String key, String namespace);

    String getFirebaseInstanceId();

    void requestLocalization(String locale, boolean fallbackToDefaultLocale);

    String getLocalization(String key, String defaultValue);

    String getLocalizationArgs(String key, String defaultValue, String args);

    String getLocalizationMap(String key, String defaultValue, String args);

    void recordCustomException(String name, String reason, String stackTraceArray);

    void recordFPSValue(double fpsValue);

    void setApplicationPackageName(String packageName);

    void addExternalId(String externalPartner, String id);

    void removeExternalId(String externalPartner);

    void showAppRatePopup(String rejectText, String laterText, String message, String feedbackUrl, int triggerCount, int laterCount);

    void showAppSettings();
}