package io.gamedock.sdk.activities;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;

import com.androidnative.AndroidNativeBridge;
import com.google.gson.reflect.TypeToken;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

import io.gamedock.sdk.GamedockEnvironment;
import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.activities.interfaces.GamedockActivityInterface;
import io.gamedock.sdk.models.gamedata.perk.PerkItem;
import io.gamedock.sdk.models.userdata.inventory.UniquePlayerItem;
import io.gamedock.sdk.models.userdata.mission.ContainerProgress;
import io.gamedock.sdk.models.userdata.mission.MissionProgress;
import io.gamedock.sdk.userdata.UserDataCallbacks;
import io.gamedock.sdk.userdata.UserDataTransaction;
import io.gamedock.sdk.utils.logging.LoggingUtil;
import io.gamedock.sdk.utils.storage.StorageUtil;

/**
 * Activity that extends the Unity Activity.
 * Entry point for all the actions that can be taken using Unity.
 * Contains methods that call the SpilSDK class.
 * Workaround for Games that use AndroidNative plugin.
 */
public class GamedockUnityActivityWithAN extends AndroidNativeBridge implements GamedockActivityInterface {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        GamedockSDK.resetContext(this);

        String environment = GamedockSDK.getInstance(this).getStorageUtil().getString(StorageUtil.Keys.UnitySDKEnvironment, GamedockEnvironment.PRODUCTION.getName());

        if (environment.equals(GamedockEnvironment.PRODUCTION.getName())) {
            GamedockSDK.getInstance(this).setEnvironment(GamedockEnvironment.PRODUCTION);
        } else {
            GamedockSDK.getInstance(this).setEnvironment(GamedockEnvironment.STAGING);
        }

        GamedockSDK.getInstance(this).onCreate();

        GamedockSDK.getInstance(this).requestAllDangerousPermissions();

        try {
            Class.forName("android.os.AsyncTask");
        } catch (Throwable ignore) {
            // ignored
        }
    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        GamedockSDK.getInstance(this).onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();

        GamedockSDK.getInstance(this).onPause();
    }

    @Override
    public void onResume() {
        try {
            super.onResume();
        } catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }

        GamedockSDK.getInstance(this).onResume();
    }

    @Override
    protected void onStart() {
        super.onStart();

        GamedockSDK.getInstance(this).onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();

        GamedockSDK.getInstance(this).onDestroy();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();

        GamedockSDK.getInstance(this).onBackPressed();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        GamedockSDK.getInstance(this).onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void init(boolean withPrivacyPolicy, boolean coppaEnabled) {
        GamedockSDK.getInstance(this).init(withPrivacyPolicy, coppaEnabled);
    }

    public void init(boolean withPrivacyPolicy, boolean coppaEnabled, String externalIds) {
        Type listType = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap<String, String> externalIdsList = new HashMap<>();
        if (externalIds != null) {
            externalIdsList = GamedockSDK.getInstance(this).getGson().fromJson(externalIds, listType);
        }
        GamedockSDK.getInstance(this).init(withPrivacyPolicy, coppaEnabled, externalIdsList);
    }

    public void resetData() {
        GamedockSDK.getInstance(this).resetData();
    }

    public void checkAgeGate(boolean shouldBlock, int requiredAged) {
        GamedockSDK.getInstance(this).checkAgeGate(shouldBlock, requiredAged,true);
    }

    public void checkPrivacyPolicy() {
        GamedockSDK.getInstance(this).checkPrivacyPolicy(true);
    }

    public void showPrivacyPolicySettings() {
        GamedockSDK.getInstance(this).showPrivacyPolicySettings();
    }

    public void savePrivValue(int priv) {
        GamedockSDK.getInstance(this).savePrivValue(priv);
    }

    public String getPrivValue() {
        return String.valueOf(GamedockSDK.getInstance(this).getPrivValue());
    }

    public void trackEvent(String eventName, String parameters) {
        try {
            if (parameters != null && !parameters.equals("null")) {
                GamedockSDK.getInstance(this).trackSpecialEvent(eventName, new JSONObject(parameters), null);
            } else {
                GamedockSDK.getInstance(this).trackSpecialEvent(eventName, new JSONObject(), null);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void confirmUserIdChange() {
        GamedockSDK.getInstance(this).confirmUserIdChange();
    }

    public void enableNotifications() {
        GamedockSDK.getInstance(this).enableNotifications();
    }

    public void disableNotification() {
        GamedockSDK.getInstance(this).disableNotifications();
    }

    public void registerDevice(String store) {
        GamedockSDK.getInstance(this).registerDevice(store);
    }

    public void requestGameConfig() {
        GamedockSDK.getInstance(this).requestConfig();
    }
    
    public String getConfigAll(boolean withSdkConfig) {
        return GamedockSDK.getInstance(this).getConfigAll(withSdkConfig);
    }

    public String getConfigValue(String key) {
        return GamedockSDK.getInstance(this).getConfigValue(key);
    }

    public void validateSubscription(String skuId, String transactionId, String token) {
        GamedockSDK.getInstance(this).validateSubscription(skuId, transactionId, token);
    }

    public String getAllPackages() {
        return GamedockSDK.getInstance(this).getAllPackages();
    }

    public String getPackage(String packageId) {
        return GamedockSDK.getInstance(this).getPackage(packageId);
    }

    public void startAdMob(String adUnitId, String type) {
        LoggingUtil.d("Manually starting DFP should only be done in DEBUG Mode!!!");
    }

    public void requestAd(String provider, String adType, boolean parentalGate) {
        GamedockSDK.getInstance(this).requestAd(provider, adType, 0);
    }

    public void requestRewardVideo(String location, String rewardType) {
        GamedockSDK.getInstance(this).requestRewardVideo(location, rewardType);
    }

    public void playVideo(String location, String rewardType) {
        GamedockSDK.getInstance(this).playVideo(location, rewardType);
    }

    public void requestInterstitial() {
        GamedockSDK.getInstance(this).requestInterstitial();
    }

    public void showInterstitial(String provider) {
        GamedockSDK.getInstance(this).playInterstitial();
    }

    public void requestMoreApps() {
        GamedockSDK.getInstance(this).requestMoreApps();
    }

    public void playMoreApps() {
        GamedockSDK.getInstance(this).playMoreApps();
    }

    public void requestBannerAd(String position, String adSize) {
        GamedockSDK.getInstance(this).requestBannerAd(position, adSize);
    }
    public void showBannerAd() {
        GamedockSDK.getInstance(this).showBannerAd();
    }

    public void hideBannerAd() {
        GamedockSDK.getInstance(this).hideBannerAd();
    }

    public String isAdAvailable(String adType) {
        return String.valueOf(GamedockSDK.getInstance(this).isAdAvailable(adType));
    }

    public void setAdTestDevice(String deviceId) {
        GamedockSDK.getInstance(this).setAdTestDevice(deviceId);
    }

    public String getWallet() {
        return GamedockSDK.getInstance(this).getWallet();
    }

    public String getInventory() {
        return GamedockSDK.getInstance(this).getInventory();
    }

    public void processUserDataTransactions(String transactions, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        Type listType = new TypeToken<ArrayList<UserDataTransaction.Transaction>>(){}.getType();
        ArrayList<UserDataTransaction.Transaction> transactionsList = GamedockSDK.getInstance(this).getGson().fromJson(transactions, listType);

        UserDataTransaction.TransactionSequence transactionSequence = GamedockSDK.getInstance(this).beginUserDataTransaction();
        for (UserDataTransaction.Transaction transaction : transactionsList) {
            switch (transaction.source) {
                case UserDataTransaction.TransactionSequence.SourceWallet:
                    if (transaction.operation.equals(UserDataTransaction.TransactionSequence.OperationAdd)) {
                        transactionSequence.addCurrency(transaction.entityId, transaction.amount);
                    } else if (transaction.operation.equals(UserDataTransaction.TransactionSequence.OperationSubtract)) {
                        transactionSequence.subtractCurrency(transaction.entityId, transaction.amount);
                    }
                    break;
                case UserDataTransaction.TransactionSequence.SourceInventory:
                    switch (transaction.type) {
                        case UserDataTransaction.TransactionSequence.TypeItem:
                            if (transaction.operation.equals(UserDataTransaction.TransactionSequence.OperationAdd)) {
                                transactionSequence.addItem(transaction.entityId, transaction.amount);
                            } else if (transaction.operation.equals(UserDataTransaction.TransactionSequence.OperationSubtract)) {
                                transactionSequence.subtractItem(transaction.entityId, transaction.amount);
                            }
                            break;
                        case UserDataTransaction.TransactionSequence.TypeGacha:
                            transactionSequence.openGacha(transaction.entityId);
                            break;
                        case UserDataTransaction.TransactionSequence.TypeUniqueItem:
                            switch (transaction.operation) {
                                case UserDataTransaction.TransactionSequence.OperationAdd:
                                    transactionSequence.addUniqueItem(transaction.uniquePlayerItem);
                                    break;
                                case UserDataTransaction.TransactionSequence.OperationSubtract:
                                    transactionSequence.removeUniqueItem(transaction.uniquePlayerItem);
                                    break;
                                case UserDataTransaction.TransactionSequence.OperationUpdate:
                                    transactionSequence.updateUniqueItem(transaction.uniquePlayerItem);
                                    break;
                            }
                            break;
                    }
                    break;
            }
        }

        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);
        transactionSequence.addCustomCallback(customCallback);

        transactionSequence.submit(this, reason, reasonDetails, location, transactionId);
    }
    public String getGamedockGameData() {
        return GamedockSDK.getInstance(this).getGamedockGameData();
    }

    public String getContainersConfiguration() {
        return GamedockSDK.getInstance(this).getGson().toJson(GamedockSDK.getInstance(this).getContainersConfiguration());
    }

    public String getMissionsConfiguration() {
        return GamedockSDK.getInstance(this).getGson().toJson(GamedockSDK.getInstance(this).getMissionsConfiguration(null));
    }

    public void requestPromotions() {
        GamedockSDK.getInstance(this).requestPromotions();
    }

    public String getAllPromotions() {
        return GamedockSDK.getInstance(this).getAllPromotions();
    }

    public String getBundlePromotion(int bundleId) {
        return GamedockSDK.getInstance(this).getBundlePromotion(bundleId);
    }

    public String getPackagePromotion(String packageId) {
        return GamedockSDK.getInstance(this).getPackagePromotion(packageId);
    }

    public void showPromotionScreen(int promotionId) {
        GamedockSDK.getInstance(this).showPromotionScreen(promotionId);
    }

    public void addCurrencyToWallet(int currencyId, int delta, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        GamedockSDK.getInstance(this).addCurrencyToWallet(currencyId, delta, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public void subtractCurrencyFromWallet(int currencyId, int delta, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        GamedockSDK.getInstance(this).subtractCurrencyFromWallet(currencyId, delta, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public void addItemToInventory(int itemId, int amount, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        GamedockSDK.getInstance(this).addItemToInventory(itemId, amount, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public void subtractItemFromInventory(int itemId, int amount, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        GamedockSDK.getInstance(this).subtractItemFromInventory(itemId, amount, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public String createUniqueItem(int itemId, String uniqueId) {
        return GamedockSDK.getInstance(this).getGson().toJson(GamedockSDK.getInstance(this).createUniqueItem(itemId, uniqueId));
    }

    public void addUniqueItemToInventory(String uniquePlayerItemJSON, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        UniquePlayerItem uniquePlayerItem = GamedockSDK.getInstance(this).getGson().fromJson(uniquePlayerItemJSON, UniquePlayerItem.class);
        GamedockSDK.getInstance(this).addUniqueItemToInventory(uniquePlayerItem, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public void updateUniqueItemFromInventory(String uniquePlayerItemJSON, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        UniquePlayerItem uniquePlayerItem = GamedockSDK.getInstance(this).getGson().fromJson(uniquePlayerItemJSON, UniquePlayerItem.class);
        GamedockSDK.getInstance(this).updateUniqueItemFromInventory(uniquePlayerItem, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public void removeUniqueItemFromInventory(String uniquePlayerItemJSON, String reason, String location, String reasonDetails, String transactionId, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        UniquePlayerItem uniquePlayerItem = GamedockSDK.getInstance(this).getGson().fromJson(uniquePlayerItemJSON, UniquePlayerItem.class);
        GamedockSDK.getInstance(this).removeUniqueItemFromInventory(uniquePlayerItem, reason, reasonDetails, location, transactionId, false, customCallback);
    }

    public void buyBundle(int bundleId, String reason, String location, String reasonDetails, String transactionId, String perkItemsJSON, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        ArrayList<PerkItem> perkItems = null;
        Type listType = new TypeToken<ArrayList<PerkItem>>(){}.getType();
        if(perkItemsJSON != null) {
            perkItems = GamedockSDK.getInstance(this).getGson().fromJson(perkItemsJSON, listType);
        }
        GamedockSDK.getInstance(this).buyBundle(bundleId, reason, reasonDetails, location, transactionId, perkItems, customCallback);
    }

    public void openGacha(int gachaId, String reason, String location, String reasonDetails, String perkItemsJSON, String callbackId) {
        UserDataCallbacks customCallback = new UserDataCallbacks();
        customCallback.setCallbackId(callbackId);

        ArrayList<PerkItem> perkItems = null;
        Type listType = new TypeToken<ArrayList<PerkItem>>(){}.getType();
        if(perkItemsJSON != null) {
            perkItems = GamedockSDK.getInstance(this).getGson().fromJson(perkItemsJSON, listType);
        }
        GamedockSDK.getInstance(this).openGacha(gachaId, reason, reasonDetails, location, perkItems, false, customCallback);
    }

    public void setCurrencyLimit(int currencyId, int limit) {
        GamedockSDK.getInstance(this).setCurrencyLimit(currencyId, limit);
    }

    public void setItemLimit(int itemId, int limit) {
        GamedockSDK.getInstance(this).setItemLimit(itemId, limit);
    }

    public String getUserAllContainerProgress() {
        return GamedockSDK.getInstance(this).getGson().toJson(GamedockSDK.getInstance(this).getUserAllContainerProgress());
    }

    public String getUserAllMissionProgress() {
        return GamedockSDK.getInstance(this).getGson().toJson(GamedockSDK.getInstance(this).getUserAllMissionProgress());
    }

    public void updateContainerAndMissionProgress(String containerProgressList, String missionProgressList, String reason, String reasonDetails, String location, String transactionId) {
        Type containerListType = new TypeToken<ArrayList<ContainerProgress>>(){}.getType();
        Type missionListType = new TypeToken<ArrayList<MissionProgress>>(){}.getType();

        ArrayList<ContainerProgress> containerProgress = GamedockSDK.getInstance(this).getGson().fromJson(containerProgressList, containerListType);
        ArrayList<MissionProgress> missionProgress = GamedockSDK.getInstance(this).getGson().fromJson(missionProgressList, missionListType);

        GamedockSDK.getInstance(this).updateContainerAndMissionProgress(containerProgress, missionProgress, reason, reasonDetails, location, transactionId);
    }

    public void updateContainerProgress(String containerProgressList, String reason, String reasonDetails, String location, String transactionId) {
        Type listType = new TypeToken<ArrayList<ContainerProgress>>(){}.getType();
        ArrayList<ContainerProgress> containerProgress = GamedockSDK.getInstance(this).getGson().fromJson(containerProgressList, listType);
        GamedockSDK.getInstance(this).updateContainerProgress(containerProgress, reason, reasonDetails, location, transactionId);
    }

    public void updateMissionProgress(String missionProgressList, String reason, String reasonDetails, String location, String transactionId) {
        Type listType = new TypeToken<ArrayList<MissionProgress>>(){}.getType();
        ArrayList<MissionProgress> missionProgress = GamedockSDK.getInstance(this).getGson().fromJson(missionProgressList, listType);
        GamedockSDK.getInstance(this).updateMissionProgress(missionProgress, reason, reasonDetails, location, transactionId);
    }

    public void claimContainersReward(String containerProgressList, String reason, String reasonDetails, String location, String transactionId) {
        Type listType = new TypeToken<ArrayList<ContainerProgress>>(){}.getType();
        ArrayList<ContainerProgress> containerProgress = GamedockSDK.getInstance(this).getGson().fromJson(containerProgressList, listType);
        GamedockSDK.getInstance(this).claimContainersReward(containerProgress, reason, reasonDetails, location, transactionId);
    }

    public void claimMissionsReward(String missionProgressList, String reason, String reasonDetails, String location, String transactionId) {
        Type listType = new TypeToken<ArrayList<MissionProgress>>(){}.getType();
        ArrayList<MissionProgress> missionProgress = GamedockSDK.getInstance(this).getGson().fromJson(missionProgressList, listType);
        GamedockSDK.getInstance(this).claimMissionsReward(missionProgress, reason, reasonDetails, location, transactionId);
    }

    public String getImagePath(String url) {
        return GamedockSDK.getInstance(this).getImagePath(url);
    }

    public void requestImage(String url, int id, String imageType) {
        GamedockSDK.getInstance(this).requestImage(url, id, imageType, null);
    }

    public void clearDiskCache() {
        GamedockSDK.getInstance(this).clearDiskCache();
    }

    public void preloadItemAndBundleImages() {
        GamedockSDK.getInstance(this).preloadItemAndBundleImages();
    }

    public void resetWallet() {
        GamedockSDK.getInstance(this).resetWallet();
    }

    public void resetInventory() {
        GamedockSDK.getInstance(this).resetInventory();
    }

    public void resetPlayerData() {
        GamedockSDK.getInstance(this).resetPlayerData();
    }

    public void resetMissionData() {
        GamedockSDK.getInstance(this).resetMissionData();
    }

    public void updatePlayerData() {
        GamedockSDK.getInstance(this).updatePlayerData();
    }

    public void showZendeskWebViewHelpCenter(String url, String tags) {
        GamedockSDK.getInstance(this).showZendeskWebViewHelpCenter(url, tags);
    }

    public String getGamedockUserId() {
        return GamedockSDK.getInstance(this).getGamedockUID();
    }

    public void setUserId(String provider, String userId) {
        GamedockSDK.getInstance(this).setUserId(provider, userId);
    }

    public String getUserId() {
        return GamedockSDK.getInstance(this).getUserId();
    }

    public String getUserProvider() {
        return GamedockSDK.getInstance(this).getUserProvider();
    }

    public void requestUserData() {
        GamedockSDK.getInstance(this).requestUserData();
    }

    public void setPublicGameState(String gameState) {
        GamedockSDK.getInstance(this).setPublicGameState(gameState, null);
    }

    public String getPublicGameState() {
        return GamedockSDK.getInstance(this).getPublicGameState();
    }

    public void setPrivateGameState(String gameState) {
        GamedockSDK.getInstance(this).setPrivateGameState(gameState, null);
    }

    public String getPrivateGameState() {
        return GamedockSDK.getInstance(this).getPrivateGameState();
    }

    public void getOtherUsersGameState(String provider, String userIdsList) {
        GamedockSDK.getInstance(this).requestOtherUsersGameState(provider, userIdsList);
    }

    public void claimToken(String token, String rewardType) {
        GamedockSDK.getInstance(this).claimToken(token, rewardType);
    }

    public void mergeUserData(String mergeData, String mergeType) {
        GamedockSDK.getInstance(this).mergeUserData(mergeData, mergeType);
    }

    public void showMergeConflictDialog(String title, String message, String localButton, String remoteButton, String mergeButton) {
        GamedockSDK.getInstance(this).showMergeConflictDialog(title, message, localButton, remoteButton, mergeButton);
    }

    public void showSyncErrorDialog(String title, String message, String mergeButton) {
        GamedockSDK.getInstance(this).showSyncErrorDialog(title, message, mergeButton);
    }

    public void showMergeFailedDialog(String title, String message, String retryButton, String mergeData, String mergeType) {
        GamedockSDK.getInstance(this).showMergeFailedDialog(title, message, retryButton, mergeData, mergeType);
    }

    public void requestDailyBonus() {
        GamedockSDK.getInstance(this).requestDailyBonus();
    }

    public void showDailyBonus() {
        GamedockSDK.getInstance(this).showDailyBonus();
    }

    public String getDailyBonusConfig() {
        return GamedockSDK.getInstance(this).getDailyBonusConfig();
    }

    public void collectDailyBonus() {
        GamedockSDK.getInstance(this).collectDailyBonus();
    }

    public void requestSplashScreen(String type) {
        GamedockSDK.getInstance(this).requestSplashScreen(type);
    }

    public void showSplashScreen() {
        GamedockSDK.getInstance(this).showSplashScreen();
    }

    public void requestServerTime() {
        GamedockSDK.getInstance(this).requestServerTime();
    }

    public void requestTieredEvents() {
        GamedockSDK.getInstance(this).requestTieredEvents();
    }

    public String getAllTieredEvents() {
        return GamedockSDK.getInstance(this).getAllTieredEvents();
    }

    public String getTieredEventProgress(int tieredEventId) {
        return GamedockSDK.getInstance(this).getTieredEventProgress(tieredEventId);
    }

    public void showTieredEventProgress(int tieredEventId) {
        GamedockSDK.getInstance(this).showTierProgress(tieredEventId);
    }

    public void claimTierReward(int tieredEventId, int tierId) {
        GamedockSDK.getInstance(this).claimTierReward(tieredEventId, tierId);
    }

    public void userLogin(String socialId, String socialProvider, String socialToken, String socialValidationData) {
        GamedockSDK.getInstance(this).userLogin(socialId, socialProvider, socialToken, socialValidationData);
    }

    public void userLogout(boolean global) {
        GamedockSDK.getInstance(this).userLogout(global);
    }

    public void userPlayAsGuest() {
        GamedockSDK.getInstance(this).userPlayAsGuest();
    }

    public void showUnauthorizedDialog(String title, String message, String loginText, String playAsGuestText) {
        GamedockSDK.getInstance(this).showUnauthorizedDialog(title, message, loginText, playAsGuestText);
    }

    public String isLoggedIn() {
        return String.valueOf(GamedockSDK.getInstance(this).isLoggedIn());
    }

    public String getDeviceId() {
        return GamedockSDK.getInstance(this).getDeviceId();
    }

    public void showNativeDialog(String title, String message, String buttonText) {
        GamedockSDK.getInstance(this).showNativeDialog(title, message, buttonText);
    }

    public void setPluginInformation(String pluginName, String pluginVersion) {
        GamedockSDK.getInstance(this).setPluginInformation(pluginName, pluginVersion);
    }

    public void requestAssetBundles() {
        GamedockSDK.getInstance(this).requestAssetBundles();
    }

    public String getAssetBundles() {
        return GamedockSDK.getInstance(this).getAssetBundles();
    }

    public void requestFirebaseRemoteConfig(long cacheExpiration) {
        GamedockSDK.getInstance(this).requestFirebaseRemoteConfig(cacheExpiration);
    }

    public void setFirebaseRemoteConfigDefaults(String defaultValues) {
        GamedockSDK.getInstance(this).setFirebaseRemoteConfigDefaults(defaultValues);
    }

    public String getBooleanFirebaseRemoteConfig(String key, String namespace) {
        return String.valueOf(GamedockSDK.getInstance(this).getBooleanFirebaseRemoteConfig(key, namespace));
    }

    public String getDoubleFirebaseRemoteConfig(String key, String namespace) {
        return String.valueOf(GamedockSDK.getInstance(this).getDoubleFirebaseRemoteConfig(key, namespace));
    }

    public String getLongFirebaseRemoteConfig(String key, String namespace) {
        return String.valueOf(GamedockSDK.getInstance(this).getLongFirebaseRemoteConfig(key, namespace));
    }

    public String getStringFirebaseRemoteConfig(String key, String namespace) {
        return GamedockSDK.getInstance(this).getStringFirebaseRemoteConfig(key, namespace);
    }

    public String getFirebaseInstanceId() {
        return GamedockSDK.getInstance(this).getFirebaseInstanceId();
    }

    public void requestLocalization(String locale, boolean fallbackToDefaultLocale) {
        GamedockSDK.getInstance(this).requestLocalization(locale, fallbackToDefaultLocale);
    }

    public String getLocalization(String key, String defaultValue) {
        return GamedockSDK.getInstance(this).getLocalization(key, defaultValue);
    }

    public String getLocalizationArgs(String key, String defaultValue, String args) {
        Type listType = new TypeToken<String[]>(){}.getType();
        String[] argsValues = GamedockSDK.getInstance(this).getGson().fromJson(args, listType);

        return GamedockSDK.getInstance(this).getLocalization(key, defaultValue, argsValues);
    }

    public String getLocalizationMap(String key, String defaultValue, String args) {
        Type listType = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap<String, String> argsValues = new HashMap<>();
        if (args != null) {
            argsValues = GamedockSDK.getInstance(this).getGson().fromJson(args, listType);
        }

        return GamedockSDK.getInstance(this).getLocalization(key, defaultValue, argsValues);
    }

    public void recordCustomException(String name, String reason, String stackTraceArray) {
        GamedockSDK.getInstance(this).recordCustomException(name, reason, stackTraceArray);
    }

    public void recordFPSValue(double fpsValue) {
        GamedockSDK.getInstance(this).recordFPSValue(fpsValue);
    }

    public void clearLog() {
        GamedockSDK.getInstance(this).clearLog();
    }

    public String getLog() {
        return GamedockSDK.getInstance(this).getLog();
    }

    public String getFeatureVersionId(String feature) {
        return String.valueOf(GamedockSDK.getInstance(this).getFeatureVersionId(feature));
    }

    public void requestDangerousPermission(String permission, String rationale, String denyRationale) {
        GamedockSDK.getInstance(this).requestPermission(permission, rationale, denyRationale);
    }

    public void setStagingEnvironment() {
        GamedockSDK.getInstance(this).setEnvironment(GamedockEnvironment.STAGING);
        GamedockSDK.getInstance(this).getStorageUtil().putString(StorageUtil.Keys.UnitySDKEnvironment, GamedockEnvironment.STAGING.getName());
    }

    public void setProductionEnvironment() {
        GamedockSDK.getInstance(this).setEnvironment(GamedockEnvironment.PRODUCTION);
        GamedockSDK.getInstance(this).getStorageUtil().putString(StorageUtil.Keys.UnitySDKEnvironment, GamedockEnvironment.PRODUCTION.getName());
    }

    public void setApplicationPackageName(String packageName) {
        GamedockSDK.getInstance(this).setApplicationPackageName(packageName);
    }

    public void addExternalId(String externalPartner, String id) {
        GamedockSDK.getInstance(this).addExternalId(externalPartner, id);
    }

    public void removeExternalId(String externalPartner) {
        GamedockSDK.getInstance(this).removeExternalId(externalPartner);
    }

    public void showAppRatePopup(String rejectText, String laterText, String message, String feedbackUrl, int triggerCount, int laterCount) {
        GamedockSDK.getInstance(this).showAppRatePopup(rejectText, laterText, message, feedbackUrl, triggerCount, laterCount);
    }

    public void showAppSettings() {
        GamedockSDK.getInstance(this).showAppSettings();
    }
}