/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo.subscription;

import graphql.execution.reactive.SubscriptionPublisher;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.JsonUtils;
import io.fria.lilo.Lilo;
import io.fria.lilo.subscription.SubscriptionMessage;
import io.fria.lilo.subscription.SubscriptionMessageType;
import io.fria.lilo.subscription.SubscriptionSourcePublisher;
import io.fria.lilo.subscription.WebSocketSessionWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubscriptionGatewayHandler {
    @NotNull
    private final Lilo lilo;
    @NotNull
    private final Map<String, SubscriptionSourcePublisher> sessionPublishers = new ConcurrentHashMap<String, SubscriptionSourcePublisher>();

    public SubscriptionGatewayHandler(@NotNull Lilo lilo) {
        this.lilo = Objects.requireNonNull(lilo);
    }

    public void handleMessage(@Nullable WebSocketSessionWrapper session, @NotNull String message) {
        Objects.requireNonNull(session);
        Optional<SubscriptionMessage> requestOptional = JsonUtils.toObj(message, SubscriptionMessage.class);
        if (requestOptional.isEmpty()) {
            return;
        }
        SubscriptionMessage request = requestOptional.get();
        SubscriptionMessageType requestType = request.getType();
        if (SubscriptionMessageType.connection_init == requestType) {
            SubscriptionMessage response = SubscriptionMessage.builder().type(SubscriptionMessageType.connection_ack).payload(new HashMap()).build();
            session.send(JsonUtils.toStr(response));
        } else if (SubscriptionMessageType.subscribe == requestType) {
            GraphQLRequest graphQLRequest = this.payloadToQuery(request.getPayload());
            Map stitchResult = this.lilo.stitch(graphQLRequest.toExecutionInput()).toSpecification();
            this.subscribe(session, (SubscriptionPublisher)stitchResult.get("data"), Objects.requireNonNull(request.getId()));
        } else if (SubscriptionMessageType.complete == requestType) {
            this.closeSession(session);
        }
    }

    public void handleSessionClose(@Nullable WebSocketSessionWrapper session) {
        if (session == null) {
            return;
        }
        this.closeSession(session);
    }

    private void closeSession(@NotNull WebSocketSessionWrapper session) {
        String sessionId = session.getId();
        if (session.isOpen()) {
            session.close();
        }
        if (this.sessionPublishers.containsKey(sessionId)) {
            SubscriptionSourcePublisher publisher = this.sessionPublishers.get(sessionId);
            publisher.close();
            this.sessionPublishers.remove(sessionId);
        }
    }

    private GraphQLRequest payloadToQuery(Object payload) {
        Optional<GraphQLRequest> graphQLRequest = JsonUtils.toObj(JsonUtils.toStr(payload), GraphQLRequest.class);
        if (graphQLRequest.isEmpty()) {
            return null;
        }
        return graphQLRequest.get();
    }

    private void subscribe(@NotNull WebSocketSessionWrapper session, @NotNull SubscriptionPublisher publisher, @NotNull String requestId) {
        SubscriptionSourcePublisher upstream = (SubscriptionSourcePublisher)publisher.getUpstreamPublisher();
        this.sessionPublishers.put(session.getId(), upstream);
        upstream.getFlux().doOnComplete(() -> {
            SubscriptionMessage completeMessage = new SubscriptionMessage();
            completeMessage.setId(requestId);
            completeMessage.setType(SubscriptionMessageType.complete);
            Objects.requireNonNull(session).send(JsonUtils.toStr(completeMessage));
            this.closeSession(session);
        }).subscribe(payload -> {
            SubscriptionMessage subscriptionMessage = SubscriptionMessage.builder().id(requestId).type(SubscriptionMessageType.next).payload(payload).build();
            session.send(JsonUtils.toStr(subscriptionMessage));
        });
    }
}

