/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionResult;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.LiloContext;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemaSource {
    @NotNull
    final String schemaName;
    @Nullable
    RuntimeWiring runtimeWiring;
    @Nullable
    TypeDefinitionRegistry typeDefinitionRegistry;

    protected SchemaSource(@NotNull String schemaName) {
        this.schemaName = schemaName;
    }

    @NotNull
    abstract CompletableFuture<ExecutionResult> execute(@NotNull LiloContext var1, @NotNull GraphQLQuery var2, @Nullable Object var3);

    @NotNull
    public String getName() {
        return this.schemaName;
    }

    @NotNull
    public RuntimeWiring getRuntimeWiring() {
        if (this.isSchemaNotLoaded()) {
            throw new IllegalArgumentException(this.schemaName + " has not been loaded yet!");
        }
        return this.runtimeWiring;
    }

    @NotNull
    public TypeDefinitionRegistry getTypeDefinitionRegistry() {
        if (this.isSchemaNotLoaded()) {
            throw new IllegalArgumentException(this.schemaName + " has not been loaded yet!");
        }
        return this.typeDefinitionRegistry;
    }

    public void invalidate() {
        this.typeDefinitionRegistry = null;
    }

    public boolean isSchemaNotLoaded() {
        return this.typeDefinitionRegistry == null;
    }

    @NotNull
    abstract CompletableFuture<SchemaSource> loadSchema(@NotNull LiloContext var1, @Nullable Object var2);
}

