/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.fria.lilo.SchemaSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SchemaMerger {
    private SchemaMerger() {
    }

    @NotNull
    static OperationTypeNames getOperationTypeNames(TypeDefinitionRegistry typeDefinitionRegistry) {
        Optional schemaDefinitionOptional = typeDefinitionRegistry.schemaDefinition();
        if (schemaDefinitionOptional.isEmpty()) {
            return new OperationTypeNames("Query", "Mutation", "Subscription");
        }
        SchemaDefinition schemaDefinition = (SchemaDefinition)schemaDefinitionOptional.get();
        Map<String, String> names = schemaDefinition.getOperationTypeDefinitions().stream().collect(Collectors.toMap(OperationTypeDefinition::getName, d -> d.getTypeName().getName()));
        return new OperationTypeNames(names.get("query"), names.get("mutation"), names.get("subscription"));
    }

    static void mergeSchemas(@NotNull Collection<SchemaSource> schemaSources, @NotNull TypeDefinitionRegistry combinedRegistry, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull RuntimeWiring.Builder runtimeWiringBuilder) {
        String queryTypeName = null;
        String mutationTypeName = null;
        String subscriptionTypeName = null;
        ArrayList<FieldDefinition> queryFieldDefinitions = new ArrayList<FieldDefinition>();
        ArrayList<FieldDefinition> mutationFieldDefinitions = new ArrayList<FieldDefinition>();
        ArrayList<FieldDefinition> subscriptionFieldDefinitions = new ArrayList<FieldDefinition>();
        for (SchemaSource schemaSource : schemaSources) {
            if (schemaSource == null || schemaSource.isSchemaNotLoaded()) continue;
            TypeDefinitionRegistry sourceRegistry = schemaSource.getTypeDefinitionRegistry();
            OperationTypeNames operationTypeNames = SchemaMerger.getOperationTypeNames(sourceRegistry);
            queryTypeName = SchemaMerger.checkName(queryTypeName, operationTypeNames.query);
            mutationTypeName = SchemaMerger.checkName(mutationTypeName, operationTypeNames.mutation);
            subscriptionTypeName = SchemaMerger.checkName(subscriptionTypeName, operationTypeNames.subscription);
            RuntimeWiring sourceWiring = schemaSource.getRuntimeWiring();
            Map dataFetchers = sourceWiring.getDataFetchers();
            SchemaMerger.mergeFieldDefinitions(queryTypeName, queryFieldDefinitions, sourceRegistry, runtimeWiringBuilder, dataFetchers);
            SchemaMerger.mergeFieldDefinitions(mutationTypeName, mutationFieldDefinitions, sourceRegistry, runtimeWiringBuilder, dataFetchers);
            SchemaMerger.mergeFieldDefinitions(subscriptionTypeName, subscriptionFieldDefinitions, sourceRegistry, runtimeWiringBuilder, dataFetchers);
            SchemaMerger.excludeTypes(sourceRegistry, queryTypeName, mutationTypeName, subscriptionTypeName).forEach(arg_0 -> ((TypeDefinitionRegistry)combinedRegistry).add(arg_0));
            sourceRegistry.getDirectiveDefinitions().values().forEach(arg_0 -> ((TypeDefinitionRegistry)combinedRegistry).add(arg_0));
            sourceRegistry.scalars().values().forEach(arg_0 -> ((TypeDefinitionRegistry)combinedRegistry).add(arg_0));
        }
        SchemaMerger.addType(queryTypeName, queryFieldDefinitions, combinedRegistry);
        SchemaMerger.addType(mutationTypeName, mutationFieldDefinitions, combinedRegistry);
        SchemaMerger.addType(subscriptionTypeName, subscriptionFieldDefinitions, combinedRegistry);
        SchemaMerger.addSchema(queryTypeName, mutationTypeName, subscriptionTypeName, combinedRegistry);
    }

    private static void addOperationType(@Nullable String operationTypeName, @NotNull TypeDefinitionRegistry combinedRegistry, SchemaDefinition.Builder builder, String name) {
        if (operationTypeName != null && combinedRegistry.getType(operationTypeName).isPresent()) {
            builder.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name(name).typeName(TypeName.newTypeName((String)operationTypeName).build()).build());
        }
    }

    private static void addSchema(@Nullable String queryTypeName, @Nullable String mutationTypeName, @Nullable String subscriptionTypeName, @NotNull TypeDefinitionRegistry combinedRegistry) {
        SchemaDefinition.Builder builder = SchemaDefinition.newSchemaDefinition();
        SchemaMerger.addOperationType(queryTypeName, combinedRegistry, builder, "query");
        SchemaMerger.addOperationType(mutationTypeName, combinedRegistry, builder, "mutation");
        SchemaMerger.addOperationType(subscriptionTypeName, combinedRegistry, builder, "subscription");
        combinedRegistry.add((SDLDefinition)builder.build());
    }

    private static void addType(@Nullable String typeName, @NotNull List<FieldDefinition> fieldDefinitions, @NotNull TypeDefinitionRegistry combinedRegistry) {
        if (typeName == null || fieldDefinitions.isEmpty()) {
            return;
        }
        combinedRegistry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name(typeName).fieldDefinitions(fieldDefinitions).build());
    }

    @Nullable
    private static String checkName(@Nullable String globalTypeName, @Nullable String sourceTypeName) {
        if (sourceTypeName != null) {
            if (globalTypeName != null && !globalTypeName.equals(sourceTypeName)) {
                throw new IllegalArgumentException("type names don't match between sources");
            }
            return sourceTypeName;
        }
        return globalTypeName;
    }

    @NotNull
    private static List<SDLDefinition> excludeTypes(@NotNull TypeDefinitionRegistry sourceRegistry, @Nullable String queryTypeName, @Nullable String mutationTypeName, @Nullable String subscriptionTypeName) {
        return sourceRegistry.types().values().stream().filter(t -> !t.getName().equals(queryTypeName) && !t.getName().equals(mutationTypeName) && !t.getName().equals(subscriptionTypeName)).collect(Collectors.toList());
    }

    private static void mergeFieldDefinitions(@Nullable String typeName, @NotNull List<FieldDefinition> fieldDefinitions, @NotNull TypeDefinitionRegistry sourceRegistry, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull RuntimeWiring.Builder runtimeWiringBuilder, @NotNull Map<String, Map<String, DataFetcher>> dataFetchers) {
        if (typeName == null) {
            return;
        }
        Optional typeOptional = sourceRegistry.getType(typeName);
        if (typeOptional.isEmpty()) {
            return;
        }
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)typeOptional.get();
        fieldDefinitions.addAll(typeDefinition.getFieldDefinitions());
        runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)typeName).dataFetchers(dataFetchers.get(typeName)).build());
    }

    static final class OperationTypeNames {
        private final String query;
        private final String mutation;
        private final String subscription;

        OperationTypeNames(@NotNull String query, @Nullable String mutation, @Nullable String subscription) {
            this.query = query;
            this.mutation = mutation;
            this.subscription = subscription;
        }

        @Nullable
        String getMutation() {
            return this.mutation;
        }

        @NotNull
        String getQuery() {
            return this.query;
        }

        @Nullable
        String getSubscription() {
            return this.subscription;
        }
    }
}

