/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import io.fria.lilo.error.GraphQLResultError;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GraphQLResult
implements ExecutionResult {
    private Map<String, Object> data;
    private List<GraphQLResultError> errors;
    private Map<Object, Object> extensions;

    GraphQLResult() {
    }

    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public List<GraphQLError> getErrors() {
        if (this.errors == null) {
            return null;
        }
        return this.errors.stream().map(le -> le).collect(Collectors.toList());
    }

    @Nullable
    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    public boolean isDataPresent() {
        return this.data != null;
    }

    @NotNull
    public Map<String, Object> toSpecification() {
        return ExecutionResultImpl.newExecutionResult().data(this.data).errors(this.getErrors()).extensions(this.extensions).build().toSpecification();
    }
}

