/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.language.Field;
import graphql.language.OperationDefinition;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.JsonUtils;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphQLQuery {
    @NotNull
    private final String query;
    @NotNull
    private final GraphQLRequest request;
    @NotNull
    private final OperationDefinition.Operation operationType;
    @NotNull
    private final Field queryNode;
    @NotNull
    private final Map<String, Object> arguments;
    @Nullable
    private final Map<String, Object> variables;

    public GraphQLQuery(@NotNull String query, @NotNull OperationDefinition.Operation operationType, @NotNull Field queryNode, @NotNull Map<String, Object> arguments, @Nullable Map<String, Object> variables) {
        this.query = Objects.requireNonNull(query);
        this.request = JsonUtils.toObj(query, GraphQLRequest.class).orElseThrow();
        this.operationType = Objects.requireNonNull(operationType);
        this.queryNode = Objects.requireNonNull(queryNode);
        this.arguments = arguments;
        this.variables = variables;
    }

    @NotNull
    public static GraphQLQueryBuilder builder() {
        return new GraphQLQueryBuilder();
    }

    @NotNull
    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    @NotNull
    public OperationDefinition.Operation getOperationType() {
        return this.operationType;
    }

    @NotNull
    public String getQuery() {
        return this.query;
    }

    @NotNull
    public Field getQueryNode() {
        return this.queryNode;
    }

    @NotNull
    public GraphQLRequest getRequest() {
        return this.request;
    }

    @Nullable
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static final class GraphQLQueryBuilder {
        @NotNull
        private String query;
        @NotNull
        private OperationDefinition.Operation operationType;
        @NotNull
        private Field queryNode;
        @NotNull
        private Map<String, Object> arguments;
        @Nullable
        private Map<String, Object> variables;

        private GraphQLQueryBuilder() {
        }

        @NotNull
        public GraphQLQueryBuilder arguments(@NotNull Map<String, Object> argumentsParam) {
            this.arguments = argumentsParam;
            return this;
        }

        @NotNull
        public GraphQLQuery build() {
            return new GraphQLQuery(this.query, this.operationType, this.queryNode, this.arguments, this.variables);
        }

        @NotNull
        public GraphQLQueryBuilder operationType(@NotNull OperationDefinition.Operation operationTypeParam) {
            this.operationType = operationTypeParam;
            return this;
        }

        @NotNull
        public GraphQLQueryBuilder query(@NotNull String queryParam) {
            this.query = queryParam;
            return this;
        }

        @NotNull
        public GraphQLQueryBuilder queryNode(@NotNull Field queryNodeParam) {
            this.queryNode = queryNodeParam;
            return this;
        }

        @NotNull
        public GraphQLQueryBuilder variables(@Nullable Map<String, Object> variablesMap) {
            this.variables = variablesMap;
            return this;
        }
    }
}

