/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.JsonUtils;
import io.fria.lilo.LiloContext;
import io.fria.lilo.SchemaSource;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefinedSchemaSource
extends SchemaSource {
    private final String definition;
    private GraphQL graphQL;

    private DefinedSchemaSource(@NotNull String schemaName, @NotNull String definition, @NotNull RuntimeWiring runtimeWiring) {
        super(schemaName);
        this.definition = definition;
        this.runtimeWiring = runtimeWiring;
    }

    @NotNull
    public static SchemaSource create(@NotNull String schemaName, @NotNull String definition, @NotNull RuntimeWiring runtimeWiring) {
        return new DefinedSchemaSource(schemaName, definition, runtimeWiring);
    }

    @NotNull
    private static SchemaSource loadSchema(@NotNull DefinedSchemaSource schemaSource) {
        schemaSource.typeDefinitionRegistry = new SchemaParser().parse(schemaSource.definition);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(schemaSource.typeDefinitionRegistry, schemaSource.runtimeWiring);
        schemaSource.graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
        return schemaSource;
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> execute(@NotNull LiloContext liloContext, @NotNull GraphQLQuery query, @Nullable Object localContext) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<GraphQLRequest> graphQLRequestOptional = JsonUtils.toObj(query.getQuery(), GraphQLRequest.class);
            if (graphQLRequestOptional.isEmpty()) {
                throw new IllegalArgumentException("Query request is invalid: Empty query");
            }
            return this.graphQL.execute(graphQLRequestOptional.get().toExecutionInput(localContext));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<SchemaSource> loadSchema(@NotNull LiloContext context, @Nullable Object localContext) {
        return CompletableFuture.supplyAsync(() -> DefinedSchemaSource.loadSchema(this));
    }
}

