/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo.subscription;

import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.JsonUtils;
import io.fria.lilo.subscription.SubscriptionMessage;
import io.fria.lilo.subscription.SubscriptionMessageType;
import io.fria.lilo.subscription.SubscriptionSourcePublisher;
import io.fria.lilo.subscription.WebSocketSessionWrapper;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubscriptionSourceHandler {
    @NotNull
    private final GraphQLQuery query;
    @NotNull
    private final SubscriptionSourcePublisher publisher;

    public SubscriptionSourceHandler(@NotNull GraphQLQuery query, @NotNull SubscriptionSourcePublisher publisher) {
        this.query = query;
        this.publisher = publisher;
    }

    public void handleMessage(@Nullable WebSocketSessionWrapper session, @NotNull String message) {
        Objects.requireNonNull(session);
        Optional<SubscriptionMessage> requestOptional = JsonUtils.toObj(message, SubscriptionMessage.class);
        if (requestOptional.isEmpty()) {
            return;
        }
        SubscriptionMessage request = requestOptional.get();
        SubscriptionMessageType requestType = request.getType();
        if (SubscriptionMessageType.connection_ack == requestType) {
            SubscriptionMessage response = new SubscriptionMessage();
            response.setId(UUID.randomUUID().toString());
            response.setType(SubscriptionMessageType.subscribe);
            response.setPayload(Objects.requireNonNull(this.query.getRequest()));
            Objects.requireNonNull(session).send(JsonUtils.toStr(response));
        } else if (SubscriptionMessageType.next == requestType) {
            this.publisher.send(Objects.requireNonNull(request.getPayload()));
            this.publisher.getFlux().doOnComplete(() -> {
                SubscriptionMessage completeMessage = new SubscriptionMessage();
                completeMessage.setId(request.getId());
                completeMessage.setType(SubscriptionMessageType.complete);
                Objects.requireNonNull(session).send(JsonUtils.toStr(completeMessage));
            }).subscribe();
        }
    }

    public void handleSessionClose(@Nullable WebSocketSessionWrapper session) {
        this.publisher.close();
    }

    public void handleSessionStart(@Nullable WebSocketSessionWrapper session) {
        SubscriptionMessage initMessage = new SubscriptionMessage();
        initMessage.setType(SubscriptionMessageType.connection_init);
        initMessage.setPayload(new HashMap());
        Objects.requireNonNull(session).send(JsonUtils.toStr(initMessage));
    }
}

