/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionResult;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.fria.lilo.AsyncIntrospectionRetriever;
import io.fria.lilo.AsyncQueryRetriever;
import io.fria.lilo.DefaultRemoteIntrospectionRetriever;
import io.fria.lilo.DefaultRemoteQueryRetriever;
import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.GraphQLResult;
import io.fria.lilo.IntrospectionRetriever;
import io.fria.lilo.JsonUtils;
import io.fria.lilo.LiloContext;
import io.fria.lilo.QueryRetriever;
import io.fria.lilo.QueryTransformer;
import io.fria.lilo.SchemaMerger;
import io.fria.lilo.SchemaSource;
import io.fria.lilo.SyncIntrospectionRetriever;
import io.fria.lilo.SyncQueryRetriever;
import io.fria.lilo.error.InvalidLiloConfigException;
import io.fria.lilo.error.SourceDataFetcherException;
import io.fria.lilo.subscription.SubscriptionRetriever;
import io.fria.lilo.subscription.SubscriptionSourcePublisher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteSchemaSource
extends SchemaSource {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteSchemaSource.class);
    private static final String INTROSPECTION_REQUEST = JsonUtils.toStr(GraphQLRequest.builder().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").operationName("IntrospectionQuery").build());
    @NotNull
    private final IntrospectionRetriever<?> introspectionRetriever;
    @NotNull
    private final QueryRetriever<?> queryRetriever;
    @Nullable
    private final SubscriptionRetriever subscriptionRetriever;

    private RemoteSchemaSource(@NotNull String schemaName, @NotNull IntrospectionRetriever<?> introspectionRetriever, @NotNull QueryRetriever<?> queryRetriever, @Nullable SubscriptionRetriever subscriptionRetriever) {
        super(schemaName);
        this.introspectionRetriever = introspectionRetriever;
        this.queryRetriever = queryRetriever;
        this.subscriptionRetriever = subscriptionRetriever;
    }

    @NotNull
    public static SchemaSource create(@NotNull String schemaName, @NotNull String schemaUrl) {
        return new RemoteSchemaSource(Objects.requireNonNull(schemaName), new DefaultRemoteIntrospectionRetriever(schemaUrl), new DefaultRemoteQueryRetriever(schemaUrl), null);
    }

    @NotNull
    public static SchemaSource create(@NotNull String schemaName, @NotNull IntrospectionRetriever<?> introspectionRetriever, @NotNull QueryRetriever<?> queryRetriever) {
        return new RemoteSchemaSource(Objects.requireNonNull(schemaName), Objects.requireNonNull(introspectionRetriever), Objects.requireNonNull(queryRetriever), null);
    }

    @NotNull
    public static SchemaSource create(@NotNull String schemaName, @NotNull IntrospectionRetriever<?> introspectionRetriever, @NotNull QueryRetriever<?> queryRetriever, @Nullable SubscriptionRetriever subscriptionRetriever) {
        return new RemoteSchemaSource(Objects.requireNonNull(schemaName), Objects.requireNonNull(introspectionRetriever), Objects.requireNonNull(queryRetriever), subscriptionRetriever);
    }

    @Nullable
    private static Object fetchData(@NotNull CompletableFuture<ExecutionResult> graphQLResultFuture) {
        ExecutionResult graphQLResult;
        try {
            graphQLResult = graphQLResultFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        List errors = graphQLResult.getErrors();
        if (errors != null && !errors.isEmpty()) {
            throw new SourceDataFetcherException(errors);
        }
        return ((Map)graphQLResult.getData()).values().iterator().next();
    }

    @NotNull
    private static ExecutionResult toExecutionResult(@NotNull String queryResult) {
        Optional<GraphQLResult> graphQLResultOptional = JsonUtils.toObj(queryResult, GraphQLResult.class);
        if (graphQLResultOptional.isEmpty()) {
            throw new IllegalArgumentException("DataFetcher caught an empty response");
        }
        return graphQLResultOptional.get();
    }

    @Override
    @NotNull
    public CompletableFuture<ExecutionResult> execute(@NotNull LiloContext liloContext, @NotNull GraphQLQuery query, @Nullable Object localContext) {
        if (this.queryRetriever instanceof AsyncQueryRetriever) {
            AsyncQueryRetriever queryRetriever = (AsyncQueryRetriever)this.queryRetriever;
            Object queryResult = queryRetriever.get(liloContext, this, query, localContext);
            return ((CompletableFuture)queryResult).thenApply(RemoteSchemaSource::toExecutionResult);
        }
        SyncQueryRetriever queryRetriever = (SyncQueryRetriever)this.queryRetriever;
        String queryResult = queryRetriever.get(liloContext, this, query, localContext);
        return CompletableFuture.supplyAsync(() -> RemoteSchemaSource.toExecutionResult(queryResult));
    }

    @Override
    @NotNull
    public CompletableFuture<SchemaSource> loadSchema(@NotNull LiloContext liloContext, @Nullable Object localContext) {
        if (this.introspectionRetriever instanceof AsyncIntrospectionRetriever) {
            AsyncIntrospectionRetriever introspectionRetriever = (AsyncIntrospectionRetriever)this.introspectionRetriever;
            return ((CompletableFuture)((CompletableFuture)introspectionRetriever.get(liloContext, this, INTROSPECTION_REQUEST, localContext)).thenApply(res -> this.fetchIntrospection((String)res, liloContext))).exceptionally(e -> {
                LOG.error("Could not load introspection for {}", (Object)this.schemaName);
                LOG.debug("Introspection fetching exception", e);
                return this;
            });
        }
        SyncIntrospectionRetriever introspectionRetriever = (SyncIntrospectionRetriever)this.introspectionRetriever;
        return CompletableFuture.supplyAsync(() -> {
            String introspectionResponse;
            try {
                introspectionResponse = introspectionRetriever.get(liloContext, this, INTROSPECTION_REQUEST, localContext);
            }
            catch (Exception e) {
                LOG.error("Could not load introspection for {}", (Object)this.schemaName);
                LOG.debug("Introspection fetching exception", (Throwable)e);
                return this;
            }
            return this.fetchIntrospection(introspectionResponse, liloContext);
        });
    }

    @NotNull
    private CompletableFuture<Object> fetchData(@NotNull GraphQLQuery query, @NotNull LiloContext liloContext, @Nullable Object localContext) {
        if (this.queryRetriever instanceof AsyncQueryRetriever) {
            CompletableFuture<ExecutionResult> graphQLResultFuture = this.execute(liloContext, query, localContext);
            return graphQLResultFuture.thenApply(executionResult -> RemoteSchemaSource.fetchData(graphQLResultFuture));
        }
        return CompletableFuture.supplyAsync(() -> {
            CompletableFuture<ExecutionResult> graphQLResultFuture = this.execute(liloContext, query, localContext);
            return RemoteSchemaSource.fetchData(graphQLResultFuture);
        });
    }

    @NotNull
    private SchemaSource fetchIntrospection(@NotNull String introspectionResponse, @NotNull LiloContext liloContext) {
        Optional<Map<String, Object>> introspectionResultOptional = JsonUtils.toMap(introspectionResponse);
        if (introspectionResultOptional.isEmpty()) {
            throw new IllegalArgumentException("Introspection response is empty");
        }
        Optional<Map<String, Object>> dataOptional = JsonUtils.getMap(introspectionResultOptional.get(), "data");
        if (dataOptional.isEmpty()) {
            throw new IllegalArgumentException("Introspection response is not valid, requires data section");
        }
        Document schemaDoc = new IntrospectionResultToSchema().createSchemaDefinition(dataOptional.get());
        TypeDefinitionRegistry typeDefinitionRegistry = new SchemaParser().buildRegistry(schemaDoc);
        SchemaMerger.OperationTypeNames operationTypeNames = SchemaMerger.getOperationTypeNames(typeDefinitionRegistry);
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        this.typeWiring(typeDefinitionRegistry, liloContext, operationTypeNames.getQuery()).ifPresent(arg_0 -> ((RuntimeWiring.Builder)runtimeWiringBuilder).type(arg_0));
        this.typeWiring(typeDefinitionRegistry, liloContext, operationTypeNames.getMutation()).ifPresent(arg_0 -> ((RuntimeWiring.Builder)runtimeWiringBuilder).type(arg_0));
        this.typeWiring(typeDefinitionRegistry, liloContext, operationTypeNames.getSubscription()).ifPresent(arg_0 -> ((RuntimeWiring.Builder)runtimeWiringBuilder).type(arg_0));
        this.runtimeWiring = runtimeWiringBuilder.build();
        this.typeDefinitionRegistry = typeDefinitionRegistry;
        return this;
    }

    @NotNull
    private Optional<TypeRuntimeWiring> typeWiring(@NotNull TypeDefinitionRegistry typeDefinitionRegistry, @NotNull LiloContext liloContext, @Nullable String typeName) {
        if (typeName == null) {
            return Optional.empty();
        }
        TypeRuntimeWiring.Builder typeWiringBuilder = TypeRuntimeWiring.newTypeWiring((String)typeName);
        Optional typeDefinitionOptional = typeDefinitionRegistry.getType(typeName);
        if (typeDefinitionOptional.isEmpty()) {
            return Optional.empty();
        }
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)typeDefinitionOptional.get();
        List fields = typeDefinition.getFieldDefinitions();
        for (FieldDefinition field : fields) {
            typeWiringBuilder.dataFetcher(field.getName(), e -> {
                Object localContext = e.getLocalContext();
                GraphQLQuery query = QueryTransformer.extractQuery(e);
                if (query.getOperationType() == OperationDefinition.Operation.SUBSCRIPTION) {
                    if (this.subscriptionRetriever != null) {
                        SubscriptionSourcePublisher publisher = new SubscriptionSourcePublisher();
                        this.subscriptionRetriever.sendQuery(liloContext, this, query, publisher, localContext);
                        return publisher;
                    }
                    throw new InvalidLiloConfigException("There's no defined SubscriptionRetriever");
                }
                return this.fetchData(query, liloContext, localContext);
            });
        }
        return Optional.of(typeWiringBuilder.build());
    }
}

