/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.fria.lilo.SchemaSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SchemaMerger {
    private SchemaMerger() {
    }

    @NotNull
    static OperationTypeNames getOperationTypeNames(TypeDefinitionRegistry typeDefinitionRegistry) {
        Optional schemaDefinitionOptional = typeDefinitionRegistry.schemaDefinition();
        if (schemaDefinitionOptional.isEmpty()) {
            return new OperationTypeNames("Query", "Mutation");
        }
        SchemaDefinition schemaDefinition = (SchemaDefinition)schemaDefinitionOptional.get();
        Map<String, String> names = schemaDefinition.getOperationTypeDefinitions().stream().collect(Collectors.toMap(OperationTypeDefinition::getName, d -> d.getTypeName().getName()));
        return new OperationTypeNames(names.get("query"), names.get("mutation"));
    }

    static void mergeSchemas(@NotNull Collection<SchemaSource> schemaSources, @NotNull TypeDefinitionRegistry combinedRegistry, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull RuntimeWiring.Builder runtimeWiringBuilder) {
        String queryTypeName = null;
        String mutationTypeName = null;
        ArrayList<FieldDefinition> queryFieldDefinitions = new ArrayList<FieldDefinition>();
        ArrayList<FieldDefinition> mutationFieldDefinitions = new ArrayList<FieldDefinition>();
        for (SchemaSource schemaSource : schemaSources) {
            if (schemaSource == null || schemaSource.isSchemaNotLoaded()) continue;
            TypeDefinitionRegistry sourceRegistry = schemaSource.getTypeDefinitionRegistry();
            OperationTypeNames operationTypeNames = SchemaMerger.getOperationTypeNames(sourceRegistry);
            queryTypeName = SchemaMerger.checkName(queryTypeName, operationTypeNames.query);
            mutationTypeName = SchemaMerger.checkName(mutationTypeName, operationTypeNames.mutation);
            RuntimeWiring sourceWiring = schemaSource.getRuntimeWiring();
            Map dataFetchers = sourceWiring.getDataFetchers();
            SchemaMerger.mergeFieldDefinitions(queryTypeName, queryFieldDefinitions, sourceRegistry, runtimeWiringBuilder, dataFetchers);
            SchemaMerger.mergeFieldDefinitions(mutationTypeName, mutationFieldDefinitions, sourceRegistry, runtimeWiringBuilder, dataFetchers);
            SchemaMerger.excludeTypes(sourceRegistry, queryTypeName, mutationTypeName).forEach(arg_0 -> ((TypeDefinitionRegistry)combinedRegistry).add(arg_0));
            sourceRegistry.getDirectiveDefinitions().values().forEach(arg_0 -> ((TypeDefinitionRegistry)combinedRegistry).add(arg_0));
            sourceRegistry.scalars().values().forEach(arg_0 -> ((TypeDefinitionRegistry)combinedRegistry).add(arg_0));
        }
        SchemaMerger.addType(queryTypeName, queryFieldDefinitions, combinedRegistry);
        SchemaMerger.addType(mutationTypeName, mutationFieldDefinitions, combinedRegistry);
        SchemaMerger.addSchema(queryTypeName, mutationTypeName, combinedRegistry);
    }

    private static void addSchema(@Nullable String queryTypeName, @Nullable String mutationTypeName, @NotNull TypeDefinitionRegistry combinedRegistry) {
        SchemaDefinition.Builder builder = SchemaDefinition.newSchemaDefinition();
        if (queryTypeName != null && combinedRegistry.getType(queryTypeName).isPresent()) {
            builder.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name("query").typeName(TypeName.newTypeName((String)queryTypeName).build()).build());
        }
        if (mutationTypeName != null && combinedRegistry.getType(mutationTypeName).isPresent()) {
            builder.operationTypeDefinition(OperationTypeDefinition.newOperationTypeDefinition().name("mutation").typeName(TypeName.newTypeName((String)mutationTypeName).build()).build());
        }
        combinedRegistry.add((SDLDefinition)builder.build());
    }

    private static void addType(@Nullable String typeName, @NotNull List<FieldDefinition> fieldDefinitions, @NotNull TypeDefinitionRegistry combinedRegistry) {
        if (typeName == null || fieldDefinitions.isEmpty()) {
            return;
        }
        combinedRegistry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name(typeName).fieldDefinitions(fieldDefinitions).build());
    }

    @Nullable
    private static String checkName(@Nullable String globalTypeName, @Nullable String sourceTypeName) {
        if (sourceTypeName != null) {
            if (globalTypeName != null && !globalTypeName.equals(sourceTypeName)) {
                throw new IllegalArgumentException("type names don't match between sources");
            }
            return sourceTypeName;
        }
        return globalTypeName;
    }

    @NotNull
    private static List<SDLDefinition> excludeTypes(@NotNull TypeDefinitionRegistry sourceRegistry, @Nullable String queryTypeName, @Nullable String mutationTypeName) {
        return sourceRegistry.types().values().stream().filter(t -> !t.getName().equals(queryTypeName) && !t.getName().equals(mutationTypeName)).collect(Collectors.toList());
    }

    private static void mergeFieldDefinitions(@Nullable String typeName, @NotNull List<FieldDefinition> fieldDefinitions, @NotNull TypeDefinitionRegistry sourceRegistry, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull RuntimeWiring.Builder runtimeWiringBuilder, @NotNull Map<String, Map<String, DataFetcher>> dataFetchers) {
        if (typeName == null) {
            return;
        }
        Optional typeOptional = sourceRegistry.getType(typeName);
        if (typeOptional.isEmpty()) {
            return;
        }
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)typeOptional.get();
        fieldDefinitions.addAll(typeDefinition.getFieldDefinitions());
        runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)typeName).dataFetchers(dataFetchers.get(typeName)).build());
    }

    static final class OperationTypeNames {
        private final String query;
        private final String mutation;

        OperationTypeNames(@NotNull String query, @Nullable String mutation) {
            this.query = query;
            this.mutation = mutation;
        }

        @Nullable
        String getMutation() {
            return this.mutation;
        }

        @NotNull
        String getQuery() {
            return this.query;
        }
    }
}

