/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.fria.lilo.DummyCoercing;
import io.fria.lilo.IntrospectionFetchingMode;
import io.fria.lilo.SchemaMerger;
import io.fria.lilo.SchemaSource;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiloContext {
    private static final Set<String> PREDEFINED_SCALARS = Set.of("Boolean", "Float", "Int", "ID", "String");
    private static final TypeResolver INTERFACE_TYPE_RESOLVER = env -> null;
    private static final TypeResolver UNION_TYPE_RESOLVER = env -> {
        Map result = (Map)env.getObject();
        if (!result.containsKey("__typename")) {
            throw new IllegalArgumentException("Please provide __typename for union types");
        }
        return env.getSchema().getObjectType(result.get("__typename").toString());
    };
    private final DataFetcherExceptionHandler dataFetcherExceptionHandler;
    private final IntrospectionFetchingMode introspectionFetchingMode;
    private Map<String, SchemaSource> sourceMap;
    private GraphQL graphQL;

    LiloContext(@NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull IntrospectionFetchingMode introspectionFetchingMode, SchemaSource ... schemaSources) {
        this.dataFetcherExceptionHandler = Objects.requireNonNull(dataFetcherExceptionHandler);
        this.introspectionFetchingMode = Objects.requireNonNull(introspectionFetchingMode);
        this.sourceMap = Arrays.stream(schemaSources).collect(Collectors.toMap(SchemaSource::getName, ss -> ss));
    }

    private static RuntimeWiring finalizeWiring(@NotNull TypeDefinitionRegistry typeRegistry, @NotNull RuntimeWiring.Builder runtimeWiringBuilder) {
        DummyCoercing dummyCoercing = new DummyCoercing();
        typeRegistry.scalars().values().stream().filter(sd -> !PREDEFINED_SCALARS.contains(sd.getName())).forEach(sd -> runtimeWiringBuilder.scalar(GraphQLScalarType.newScalar().name(sd.getName()).coercing((Coercing)dummyCoercing).build()));
        typeRegistry.types().values().stream().filter(t -> t instanceof InterfaceTypeDefinition || t instanceof UnionTypeDefinition).forEach(t -> {
            if (t instanceof InterfaceTypeDefinition) {
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)t.getName()).typeResolver(INTERFACE_TYPE_RESOLVER));
            } else {
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)t.getName()).typeResolver(UNION_TYPE_RESOLVER));
            }
        });
        return runtimeWiringBuilder.build();
    }

    @NotNull
    public DataFetcherExceptionHandler getDataFetcherExceptionHandler() {
        return this.dataFetcherExceptionHandler;
    }

    @NotNull
    public GraphQL getGraphQL() {
        return this.getGraphQL(null);
    }

    @NotNull
    public IntrospectionFetchingMode getIntrospectionFetchingMode() {
        return this.introspectionFetchingMode;
    }

    @NotNull
    public Map<String, SchemaSource> getSchemaSources() {
        return Map.copyOf(this.sourceMap);
    }

    public void invalidate(@NotNull String schemaName) {
        if (!this.sourceMap.containsKey(Objects.requireNonNull(schemaName))) {
            return;
        }
        SchemaSource schemaSource = this.sourceMap.get(schemaName);
        schemaSource.invalidate();
        this.graphQL = null;
    }

    public void invalidateAll() {
        this.sourceMap.values().forEach(SchemaSource::invalidate);
        this.graphQL = null;
    }

    @NotNull
    synchronized GraphQL getGraphQL(@Nullable ExecutionInput executionInput) {
        if (this.graphQL == null) {
            Map<String, SchemaSource> sourceMapClone = this.loadSources(executionInput);
            this.graphQL = this.createGraphQL(sourceMapClone);
            this.sourceMap = sourceMapClone;
        }
        return this.graphQL;
    }

    @NotNull
    private GraphQL createGraphQL(@NotNull Map<String, SchemaSource> schemaSourceMap) {
        TypeDefinitionRegistry combinedRegistry = new TypeDefinitionRegistry();
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        SchemaMerger.mergeSchemas(schemaSourceMap.values(), combinedRegistry, runtimeWiringBuilder);
        RuntimeWiring runtimeWiring = LiloContext.finalizeWiring(combinedRegistry, runtimeWiringBuilder);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(combinedRegistry, runtimeWiring);
        return GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).defaultDataFetcherExceptionHandler(this.dataFetcherExceptionHandler).build();
    }

    @NotNull
    private Map<String, SchemaSource> loadSources(@Nullable ExecutionInput executionInput) {
        Object localContext = executionInput == null ? null : executionInput.getLocalContext();
        return this.sourceMap.values().stream().peek(ss -> {
            if (!ss.isSchemaLoaded()) {
                ss.loadSchema(this, localContext);
            }
        }).collect(Collectors.toMap(SchemaSource::getName, ss -> ss));
    }
}

