/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionInput;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphQLRequest {
    public static final String INTROSPECTION_QUERY = "\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n";
    private String query;
    private String operationName;
    private Map<String, Object> variables;

    public GraphQLRequest(@NotNull String query, @Nullable String operationName, @Nullable Map<String, Object> variables) {
        this.query = Objects.requireNonNull(query);
        this.operationName = operationName;
        this.variables = variables;
    }

    public GraphQLRequest() {
    }

    @NotNull
    public static GraphQLRequestBuilder builder() {
        return new GraphQLRequestBuilder();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphQLRequest that = (GraphQLRequest)o;
        return this.query.equals(that.query) && Objects.equals(this.operationName, that.operationName) && Objects.equals(this.variables, that.variables);
    }

    @Nullable
    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(@Nullable String operationName) {
        this.operationName = operationName;
    }

    @NotNull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@NotNull String query) {
        this.query = Objects.requireNonNull(query);
    }

    @Nullable
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(@Nullable Map<String, Object> variables) {
        this.variables = variables;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.operationName, this.variables);
    }

    @NotNull
    public ExecutionInput toExecutionInput(@Nullable Object localContext) {
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput().query(this.query);
        if (this.operationName != null) {
            builder.operationName(this.operationName);
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            builder.variables(this.variables);
        }
        if (localContext != null) {
            builder.localContext(localContext);
        }
        return builder.build();
    }

    @NotNull
    public ExecutionInput toExecutionInput() {
        return this.toExecutionInput(null);
    }

    @NotNull
    public String toString() {
        return "GraphQLRequest(query=" + this.getQuery() + ", operationName=" + this.getOperationName() + ", variables=" + this.getVariables() + ")";
    }

    public static final class GraphQLRequestBuilder {
        private String query;
        private String operationName;
        private Map<String, Object> variables;

        private GraphQLRequestBuilder() {
        }

        @NotNull
        public GraphQLRequest build() {
            return new GraphQLRequest(this.query, this.operationName, this.variables);
        }

        @NotNull
        public GraphQLRequestBuilder operationName(@Nullable String operationNameParam) {
            this.operationName = operationNameParam;
            return this;
        }

        @NotNull
        public GraphQLRequestBuilder query(@NotNull String queryParam) {
            this.query = Objects.requireNonNull(queryParam);
            return this;
        }

        @NotNull
        public GraphQLRequestBuilder variables(@Nullable Map<String, Object> variablesParam) {
            this.variables = variablesParam;
            return this;
        }
    }
}

