/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.JsonUtils;
import io.fria.lilo.LiloContext;
import io.fria.lilo.SchemaSource;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefinedSchemaSource
implements SchemaSource {
    private final String schemaName;
    private final String definition;
    private final RuntimeWiring runtimeWiring;
    private TypeDefinitionRegistry typeDefinitionRegistry;
    private GraphQL graphQL;

    private DefinedSchemaSource(@NotNull String schemaName, @NotNull String definition, @NotNull RuntimeWiring runtimeWiring) {
        this.schemaName = schemaName;
        this.definition = definition;
        this.runtimeWiring = runtimeWiring;
    }

    @NotNull
    public static SchemaSource create(@NotNull String schemaName, @NotNull String definition, @NotNull RuntimeWiring runtimeWiring) {
        return new DefinedSchemaSource(schemaName, definition, runtimeWiring);
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull LiloContext liloContext, @NotNull SchemaSource schemaSource, @NotNull GraphQLQuery query, @Nullable Object localContext) {
        Optional<GraphQLRequest> graphQLRequestOptional = JsonUtils.toObj(query.getQuery(), GraphQLRequest.class);
        if (graphQLRequestOptional.isEmpty()) {
            throw new IllegalArgumentException("Query request is invalid: Empty query");
        }
        return this.graphQL.execute(graphQLRequestOptional.get().toExecutionInput(localContext));
    }

    @Override
    @NotNull
    public String getName() {
        return this.schemaName;
    }

    @Override
    @NotNull
    public RuntimeWiring getRuntimeWiring() {
        return this.runtimeWiring;
    }

    @Override
    @NotNull
    public TypeDefinitionRegistry getTypeDefinitionRegistry() {
        return this.typeDefinitionRegistry;
    }

    @Override
    public void invalidate() {
        this.typeDefinitionRegistry = null;
    }

    @Override
    public boolean isSchemaLoaded() {
        return this.typeDefinitionRegistry != null;
    }

    @Override
    public void loadSchema(@NotNull LiloContext context, @Nullable Object localContext) {
        this.typeDefinitionRegistry = new SchemaParser().parse(this.definition);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(this.typeDefinitionRegistry, this.runtimeWiring);
        this.graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
    }
}

