/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import io.fria.lilo.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SchemaMerger {
    private SchemaMerger() {
    }

    @NotNull
    static OperationTypeNames getOperationTypeNames(@NotNull Map<String, Object> sourceSchema) {
        Optional<String> mutationTypeNameOptional;
        Optional<Map<String, Object>> queryTypeOptional = JsonUtils.getMap(sourceSchema, "queryType");
        if (queryTypeOptional.isEmpty()) {
            throw new IllegalArgumentException("source schema should contain a queryType section");
        }
        Optional<String> queryTypeNameOptional = JsonUtils.getName(queryTypeOptional.get());
        if (queryTypeNameOptional.isEmpty()) {
            throw new IllegalArgumentException("queryType section in source schema cannot be empty");
        }
        Optional<Map<String, Object>> mutationTypeOptional = JsonUtils.getMap(sourceSchema, "mutationType");
        String mutationTypeName = null;
        if (mutationTypeOptional.isPresent() && (mutationTypeNameOptional = JsonUtils.getName(mutationTypeOptional.get())).isPresent()) {
            mutationTypeName = mutationTypeNameOptional.get();
        }
        return new OperationTypeNames(queryTypeNameOptional.get(), mutationTypeName);
    }

    static void mergeSchema(@NotNull Map<String, Object> targetSchema, @NotNull Map<String, Object> sourceSchema) {
        if (targetSchema.isEmpty()) {
            targetSchema.putAll(sourceSchema);
            return;
        }
        SchemaMerger.mergeTypeName(targetSchema, sourceSchema, "queryType");
        SchemaMerger.mergeTypeName(targetSchema, sourceSchema, "mutationType");
        SchemaMerger.mergeSchemaTypes(targetSchema, sourceSchema);
        SchemaMerger.mergeSchemaDirectives(targetSchema, sourceSchema);
    }

    private static void addFields(@Nullable String typeName, @NotNull Map<String, Object> typeDefinition, @NotNull Map<String, Map<String, Object>> targetTypeMap) {
        if (typeName == null) {
            return;
        }
        Optional<String> typeDefinitionNameOptional = JsonUtils.getName(typeDefinition);
        if (typeDefinitionNameOptional.isEmpty()) {
            return;
        }
        String typeDefinitionName = typeDefinitionNameOptional.get();
        if (!typeDefinitionName.equals(typeName)) {
            return;
        }
        Map<String, Object> targetQueryTypeDefinition = targetTypeMap.get(typeDefinitionName);
        List fields = JsonUtils.getMapList(targetQueryTypeDefinition, "fields").orElse(List.of());
        Map<String, Map> targetFields = fields.stream().collect(Collectors.toMap(f -> f.get("name").toString(), f -> f));
        JsonUtils.getMapList(typeDefinition, "fields").orElse(List.of()).forEach(f -> {
            Optional<String> fieldNameOptional = JsonUtils.getName(f);
            if (fieldNameOptional.isPresent() && !targetFields.containsKey(fieldNameOptional.get())) {
                fields.add(f);
            }
        });
    }

    private static void addFields(@NotNull Map<String, Object> sourceSchemaTypes, @NotNull List<Map<String, Object>> targetSchemaTypes, @NotNull Map<String, Map<String, Object>> targetTypeMap, @NotNull OperationTypeNames operationTypeNames) {
        Optional<String> typeNameOptional = JsonUtils.getName(sourceSchemaTypes);
        if (typeNameOptional.isEmpty()) {
            return;
        }
        String typeName = typeNameOptional.get();
        if (!targetTypeMap.containsKey(typeName)) {
            targetSchemaTypes.add(sourceSchemaTypes);
            targetTypeMap.put(typeName, sourceSchemaTypes);
        }
        SchemaMerger.addFields(operationTypeNames.queryTypeName, sourceSchemaTypes, targetTypeMap);
        SchemaMerger.addFields(operationTypeNames.mutationTypeName, sourceSchemaTypes, targetTypeMap);
    }

    private static void mergeSchemaDirectives(@NotNull Map<String, Object> targetSchema, @NotNull Map<String, Object> sourceSchema) {
        List<Object> targetSchemaDirectives;
        Optional<List<Map<String, Object>>> sourceSchemaDirectivesOptional = JsonUtils.getMapList(sourceSchema, "directives");
        if (sourceSchemaDirectivesOptional.isEmpty()) {
            return;
        }
        Optional<List<Map<String, Object>>> targetSchemaDirectivesOptional = JsonUtils.getMapList(targetSchema, "directives");
        if (targetSchemaDirectivesOptional.isEmpty()) {
            targetSchemaDirectives = new ArrayList();
            targetSchema.put("directives", targetSchemaDirectives);
        } else {
            targetSchemaDirectives = targetSchemaDirectivesOptional.get();
        }
        Map<String, Map> targetDirectiveMap = targetSchemaDirectives.stream().collect(Collectors.toMap(d -> d.get("name").toString(), d -> d));
        sourceSchemaDirectivesOptional.get().forEach(sd -> {
            Optional<String> sdOptional = JsonUtils.getName(sd);
            if (sdOptional.isPresent() && !targetDirectiveMap.containsKey(sdOptional.get())) {
                targetSchemaDirectives.add(sd);
            }
        });
    }

    private static void mergeSchemaTypes(@NotNull Map<String, Object> targetSchema, @NotNull Map<String, Object> sourceSchema) {
        List<Object> targetSchemaTypes;
        Optional<List<Map<String, Object>>> sourceSchemaTypesOptional = JsonUtils.getMapList(sourceSchema, "types");
        if (sourceSchemaTypesOptional.isEmpty()) {
            return;
        }
        Optional<List<Map<String, Object>>> targetSchemaTypesOptional = JsonUtils.getMapList(targetSchema, "types");
        if (targetSchemaTypesOptional.isEmpty()) {
            targetSchemaTypes = new ArrayList();
            targetSchema.put("types", targetSchemaTypes);
        } else {
            targetSchemaTypes = targetSchemaTypesOptional.get();
        }
        Map<String, Map> targetTypeMap = targetSchemaTypes.stream().collect(Collectors.toMap(st -> st.get("name").toString(), st -> st));
        OperationTypeNames operationTypeNames = SchemaMerger.getOperationTypeNames(sourceSchema);
        sourceSchemaTypesOptional.get().forEach(st -> SchemaMerger.addFields(st, targetSchemaTypes, targetTypeMap, operationTypeNames));
    }

    private static void mergeTypeName(@NotNull Map<String, Object> targetSchema, @NotNull Map<String, Object> sourceSchema, @NotNull String typeNameKey) {
        Optional<Map<String, Object>> sourceSchemaQueryTypeOptional = JsonUtils.getMap(sourceSchema, typeNameKey);
        if (sourceSchemaQueryTypeOptional.isEmpty()) {
            return;
        }
        Map<String, Object> sourceSchemaQueryType = sourceSchemaQueryTypeOptional.get();
        Optional<Map<String, Object>> targetSchemaQueryTypeOptional = JsonUtils.getMap(targetSchema, typeNameKey);
        if (targetSchemaQueryTypeOptional.isEmpty()) {
            targetSchema.put(typeNameKey, sourceSchemaQueryType);
        } else {
            Map<String, Object> targetSchemaQueryType = targetSchemaQueryTypeOptional.get();
            if (!JsonUtils.getName(sourceSchemaQueryType).equals(JsonUtils.getName(targetSchemaQueryType))) {
                throw new IllegalArgumentException("type name mismatches");
            }
        }
    }

    static final class OperationTypeNames {
        private final String queryTypeName;
        private final String mutationTypeName;

        OperationTypeNames(@NotNull String queryTypeName, @Nullable String mutationTypeName) {
            this.queryTypeName = queryTypeName;
            this.mutationTypeName = mutationTypeName;
        }

        @Nullable
        String getMutationTypeName() {
            return this.mutationTypeName;
        }

        @NotNull
        String getQueryTypeName() {
            return this.queryTypeName;
        }
    }
}

