/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.fria.lilo.DummyCoercing;
import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.IntrospectionFetchingMode;
import io.fria.lilo.JsonUtils;
import io.fria.lilo.QueryTransformer;
import io.fria.lilo.SchemaMerger;
import io.fria.lilo.SchemaSource;
import io.fria.lilo.error.LiloGraphQLError;
import io.fria.lilo.error.SourceDataFetcherException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiloContext {
    private static final Logger LOG = LoggerFactory.getLogger(LiloContext.class);
    private static final Set<String> PREDEFINED_SCALARS = Set.of("Boolean", "Float", "Int", "ID", "String");
    private static final TypeResolver INTERFACE_TYPE_RESOLVER = env -> null;
    private static final String INTROSPECTION_REQUEST = JsonUtils.toStr(GraphQLRequest.builder().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\nfragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n\n").operationName("IntrospectionQuery").build());
    private static final TypeResolver UNION_TYPE_RESOLVER = env -> {
        Map result = (Map)env.getObject();
        if (!result.containsKey("__typename")) {
            throw new IllegalArgumentException("Please provide __typename for union types");
        }
        return env.getSchema().getObjectType(result.get("__typename").toString());
    };
    private final DataFetcherExceptionHandler dataFetcherExceptionHandler;
    private final IntrospectionFetchingMode introspectionFetchingMode;
    private Map<String, ProcessedSchemaSource> sourceMap;
    private GraphQL graphQL;

    LiloContext(@NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull IntrospectionFetchingMode introspectionFetchingMode, SchemaSource ... schemaSources) {
        this.dataFetcherExceptionHandler = Objects.requireNonNull(dataFetcherExceptionHandler);
        this.introspectionFetchingMode = Objects.requireNonNull(introspectionFetchingMode);
        this.sourceMap = Arrays.stream(schemaSources).collect(Collectors.toMap(SchemaSource::getName, x$0 -> new ProcessedSchemaSource((SchemaSource)x$0)));
    }

    @NotNull
    private static GraphQL combine(@NotNull Map<String, TypeRuntimeWiring.Builder> typeRuntimeWiringBuilders, @NotNull Map<String, Object> combinedSchemaMap, @NotNull Map<String, ScalarTypeDefinition> scalars, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        Map<String, Map<String, Object>> schemaMap = Map.of("__schema", combinedSchemaMap);
        SchemaParser parser = new SchemaParser();
        Document schemaDoc = new IntrospectionResultToSchema().createSchemaDefinition(schemaMap);
        TypeDefinitionRegistry typeRegistry = parser.buildRegistry(schemaDoc);
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        DummyCoercing dummyCoercing = new DummyCoercing();
        typeRuntimeWiringBuilders.values().forEach(arg_0 -> ((RuntimeWiring.Builder)runtimeWiringBuilder).type(arg_0));
        scalars.values().stream().filter(sd -> !PREDEFINED_SCALARS.contains(sd.getName())).forEach(sd -> runtimeWiringBuilder.scalar(GraphQLScalarType.newScalar().name(sd.getName()).coercing((Coercing)dummyCoercing).build()));
        typeRegistry.types().values().stream().filter(t -> t instanceof InterfaceTypeDefinition || t instanceof UnionTypeDefinition).forEach(t -> {
            if (t instanceof InterfaceTypeDefinition) {
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)t.getName()).typeResolver(INTERFACE_TYPE_RESOLVER));
            } else {
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)t.getName()).typeResolver(UNION_TYPE_RESOLVER));
            }
        });
        RuntimeWiring runtimeWiring = runtimeWiringBuilder.build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring);
        return GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).defaultDataFetcherExceptionHandler(dataFetcherExceptionHandler).build();
    }

    @NotNull
    public DataFetcherExceptionHandler getDataFetcherExceptionHandler() {
        return this.dataFetcherExceptionHandler;
    }

    @NotNull
    public GraphQL getGraphQL() {
        return this.getGraphQL(null);
    }

    @NotNull
    public IntrospectionFetchingMode getIntrospectionFetchingMode() {
        return this.introspectionFetchingMode;
    }

    @NotNull
    public Map<String, SchemaSource> getSchemaSources() {
        return ImmutableMap.copyOf(this.sourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ProcessedSchemaSource)e.getValue()).schemaSource)));
    }

    public void invalidate(@NotNull String schemaName) {
        if (!this.sourceMap.containsKey(Objects.requireNonNull(schemaName))) {
            return;
        }
        ProcessedSchemaSource processedSource = this.sourceMap.get(schemaName);
        processedSource.invalidate();
        this.graphQL = null;
    }

    public void invalidateAll() {
        this.sourceMap.values().forEach(rec$ -> ((ProcessedSchemaSource)rec$).invalidate());
        this.graphQL = null;
    }

    @NotNull
    GraphQL getGraphQL(@Nullable ExecutionInput executionInput) {
        if (this.graphQL == null) {
            this.createGraphQL(executionInput);
        }
        return this.graphQL;
    }

    private void assignDataFetchers(@NotNull Map<String, TypeRuntimeWiring.Builder> typeRuntimeWiringBuilders, @NotNull ProcessedSchemaSource processedSchemaSource, @Nullable String typeName) {
        if (typeName == null) {
            return;
        }
        if (!typeRuntimeWiringBuilders.containsKey(typeName)) {
            typeRuntimeWiringBuilders.put(typeName, TypeRuntimeWiring.newTypeWiring((String)typeName));
        }
        SchemaSource schemaSource = processedSchemaSource.schemaSource;
        TypeDefinitionRegistry typeDefinitionRegistry = processedSchemaSource.typeDefinitionRegistry;
        TypeRuntimeWiring.Builder typeWiringBuilder = typeRuntimeWiringBuilders.get(typeName);
        Optional typeDefinitionOptional = typeDefinitionRegistry.getType(typeName);
        if (typeDefinitionOptional.isEmpty()) {
            throw new IllegalArgumentException(String.format("Type definition %s is not found", typeName));
        }
        TypeDefinition typeDefinition = (TypeDefinition)typeDefinitionOptional.get();
        List children = typeDefinition.getChildren();
        for (FieldDefinition field : children) {
            typeWiringBuilder.dataFetcher(field.getName(), e -> this.fetchData(e, schemaSource));
        }
    }

    private void assignHandler(@NotNull ProcessedSchemaSource processedSchemaSource, @NotNull Map<String, TypeRuntimeWiring.Builder> typeRuntimeWiringBuilders, @NotNull Map<String, Object> combinedSchemaMap, @NotNull Map<String, ScalarTypeDefinition> scalars) {
        if (processedSchemaSource.schema == null) {
            return;
        }
        SchemaMerger.OperationTypeNames operationTypeNames = SchemaMerger.getOperationTypeNames(processedSchemaSource.schema);
        this.assignDataFetchers(typeRuntimeWiringBuilders, processedSchemaSource, operationTypeNames.getQueryTypeName());
        this.assignDataFetchers(typeRuntimeWiringBuilders, processedSchemaSource, operationTypeNames.getMutationTypeName());
        scalars.putAll(processedSchemaSource.typeDefinitionRegistry.scalars());
        SchemaMerger.mergeSchema(combinedSchemaMap, processedSchemaSource.schema);
    }

    private synchronized void createGraphQL(@Nullable ExecutionInput executionInput) {
        Map<String, ProcessedSchemaSource> sourceMapClone = this.processInvalidatedSources(executionInput);
        this.graphQL = this.createGraphQL(sourceMapClone);
        this.sourceMap = sourceMapClone;
    }

    @NotNull
    private GraphQL createGraphQL(@NotNull Map<String, ProcessedSchemaSource> processedSchemaSourceMap) {
        HashMap<String, Object> combinedSchemaMap = new HashMap<String, Object>();
        HashMap<String, TypeRuntimeWiring.Builder> typeRuntimeWiringBuilders = new HashMap<String, TypeRuntimeWiring.Builder>();
        HashMap<String, ScalarTypeDefinition> scalars = new HashMap<String, ScalarTypeDefinition>();
        processedSchemaSourceMap.values().forEach(pss -> this.assignHandler((ProcessedSchemaSource)pss, (Map<String, TypeRuntimeWiring.Builder>)typeRuntimeWiringBuilders, (Map<String, Object>)combinedSchemaMap, (Map<String, ScalarTypeDefinition>)scalars));
        return LiloContext.combine(typeRuntimeWiringBuilders, combinedSchemaMap, scalars, this.dataFetcherExceptionHandler);
    }

    @Nullable
    private Object fetchData(@NotNull DataFetchingEnvironment environment, @NotNull SchemaSource schemaSource) {
        GraphQLQuery request = QueryTransformer.extractQuery(environment);
        String queryResult = schemaSource.getQueryRetriever().get(this, schemaSource, request, environment.getLocalContext());
        Optional<GraphQLResult> graphQLResultOptional = JsonUtils.toObj(queryResult, GraphQLResult.class);
        if (graphQLResultOptional.isEmpty()) {
            throw new IllegalArgumentException("DataFetcher caught an empty response");
        }
        GraphQLResult graphQLResult = graphQLResultOptional.get();
        List<LiloGraphQLError> errors = graphQLResult.errors;
        if (errors != null && !errors.isEmpty()) {
            throw new SourceDataFetcherException(errors);
        }
        return graphQLResult.data.values().iterator().next();
    }

    @NotNull
    private Map<String, ProcessedSchemaSource> processInvalidatedSources(@Nullable ExecutionInput executionInput) {
        Object localContext = executionInput == null ? null : executionInput.getLocalContext();
        return this.sourceMap.values().stream().peek(ps -> {
            if (ps.isNotProcessed()) {
                ps.process(localContext);
            }
        }).collect(Collectors.toMap(ps -> ps.schemaSource.getName(), ps -> ps));
    }

    private final class ProcessedSchemaSource {
        private final SchemaSource schemaSource;
        private Map<String, Object> schema;
        private TypeDefinitionRegistry typeDefinitionRegistry;

        private ProcessedSchemaSource(SchemaSource schemaSource) {
            this.schemaSource = Objects.requireNonNull(schemaSource);
        }

        private void invalidate() {
            this.schema = null;
        }

        private boolean isNotProcessed() {
            return this.schema == null;
        }

        private void process(@Nullable Object localContext) {
            String introspectionResponse;
            try {
                introspectionResponse = this.schemaSource.getIntrospectionRetriever().get(LiloContext.this, this.schemaSource, INTROSPECTION_REQUEST, localContext);
            }
            catch (Exception e) {
                LOG.error("Could not load introspection for {}", (Object)this.schemaSource.getName());
                LOG.debug("Introspection fetching exception", (Throwable)e);
                return;
            }
            Optional<Map<String, Object>> introspectionResultOptional = JsonUtils.toMap(introspectionResponse);
            if (introspectionResultOptional.isEmpty()) {
                throw new IllegalArgumentException("Introspection response is empty");
            }
            Optional<Map<String, Object>> dataOptional = JsonUtils.getMap(introspectionResultOptional.get(), "data");
            if (dataOptional.isEmpty()) {
                throw new IllegalArgumentException("Introspection response is not valid, requires data section");
            }
            Optional<Map<String, Object>> schemaOptional = JsonUtils.getMap(dataOptional.get(), "__schema");
            if (schemaOptional.isEmpty()) {
                throw new IllegalArgumentException("Introspection response is not valid, requires __schema section");
            }
            Document schemaDoc = new IntrospectionResultToSchema().createSchemaDefinition(dataOptional.get());
            this.typeDefinitionRegistry = new SchemaParser().buildRegistry(schemaDoc);
            this.schema = schemaOptional.get();
        }
    }

    private static final class GraphQLResult {
        private Map<String, Object> data;
        private List<LiloGraphQLError> errors;

        private GraphQLResult() {
        }

        @NotNull
        public Map<String, Object> getData() {
            return this.data;
        }

        @NotNull
        public List<LiloGraphQLError> getErrors() {
            return this.errors;
        }
    }
}

