/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.execution.DataFetcherExceptionHandler;
import io.fria.lilo.IntrospectionFetchingMode;
import io.fria.lilo.LiloContext;
import io.fria.lilo.SchemaSource;
import io.fria.lilo.error.SourceDataFetcherExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Lilo {
    private final LiloContext context;

    private Lilo(@NotNull LiloContext context) {
        this.context = context;
    }

    @NotNull
    public static LiloBuilder builder() {
        return new LiloBuilder();
    }

    @NotNull
    public LiloContext getContext() {
        return this.context;
    }

    @NotNull
    public ExecutionResult stitch(@NotNull ExecutionInput executionInput) {
        if (IntrospectionFetchingMode.FETCH_BEFORE_EVERY_REQUEST == this.context.getIntrospectionFetchingMode()) {
            this.context.invalidateAll();
        }
        return this.context.getGraphQL(executionInput).execute(executionInput);
    }

    public static final class LiloBuilder {
        private final Map<String, SchemaSource> schemaSources = new HashMap<String, SchemaSource>();
        private DataFetcherExceptionHandler dataFetcherExceptionHandler = new SourceDataFetcherExceptionHandler();
        private IntrospectionFetchingMode introspectionFetchingMode = IntrospectionFetchingMode.CACHE_UNTIL_INVALIDATION;

        private LiloBuilder() {
        }

        @NotNull
        public LiloBuilder addSource(@NotNull SchemaSource schemaSource) {
            this.schemaSources.put(schemaSource.getName(), Objects.requireNonNull(schemaSource));
            return this;
        }

        @NotNull
        public Lilo build() {
            return new Lilo(new LiloContext(this.dataFetcherExceptionHandler, this.introspectionFetchingMode, this.schemaSources.values().toArray(new SchemaSource[0])));
        }

        @NotNull
        public LiloBuilder defaultDataFetcherExceptionHandler(@NotNull DataFetcherExceptionHandler defaultDataFetcherExceptionHandler) {
            this.dataFetcherExceptionHandler = defaultDataFetcherExceptionHandler;
            return this;
        }

        @NotNull
        public LiloBuilder introspectionFetchingMode(@NotNull IntrospectionFetchingMode introspectionFetchingMode) {
            this.introspectionFetchingMode = introspectionFetchingMode;
            return this;
        }
    }
}

