/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo.error;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import io.fria.lilo.error.ErrorSourceLocation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiloGraphQLError
implements GraphQLError {
    private String message;
    private List<ErrorSourceLocation> locations;
    private ErrorType errorType;
    private List<Object> path;

    @Nullable
    public ErrorClassification getErrorType() {
        return this.errorType;
    }

    public void setErrorType(@Nullable ErrorType errorType) {
        this.errorType = errorType;
    }

    @Nullable
    public List<SourceLocation> getLocations() {
        if (this.locations == null) {
            return null;
        }
        return this.locations.stream().map(l -> new ErrorSourceLocation(l.getLine(), l.getColumn(), l.getSourceName())).collect(Collectors.toList());
    }

    public void setLocations(@Nullable List<ErrorSourceLocation> locations) {
        this.locations = locations;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@NotNull String message) {
        this.message = Objects.requireNonNull(message);
    }

    @Nullable
    public List<Object> getPath() {
        return this.path;
    }

    public void setPath(@Nullable List<Object> path) {
        this.path = path;
    }
}

