/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.spring.okhttp.autoconfigure;

import io.freefair.spring.okhttp.autoconfigure.NotReactiveWebApplicationCondition;
import io.freefair.spring.okhttp.client.OkHttpClientRequestFactory;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;

@AutoConfiguration
@ConditionalOnClass(value={RestClientCustomizer.class, RestClient.class, OkHttpClientRequestFactory.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
public class OkHttpRestClientAutoConfiguration {
    @Bean
    public RestClientCustomizer okHttpRestClientCustomizer(OkHttpClient okHttpClient) {
        return restClientBuilder -> restClientBuilder.requestFactory((ClientHttpRequestFactory)new OkHttpClientRequestFactory(okHttpClient));
    }
}

