/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.spring.okhttp.autoconfigure;

import java.io.File;
import java.time.Duration;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="okhttp")
public class OkHttpProperties {
    private Duration connectTimeout = Duration.ofSeconds(10L);
    private Duration readTimeout = Duration.ofSeconds(10L);
    private Duration writeTimeout = Duration.ofSeconds(10L);
    private Duration pingInterval = Duration.ZERO;
    @NestedConfigurationProperty
    private CacheProperties cache = new CacheProperties();
    private boolean followSslRedirects = true;
    private boolean followRedirects = true;
    private boolean retryOnConnectionFailure = true;
    @NestedConfigurationProperty
    private final ConnectionPoolProperties connectionPool = new ConnectionPoolProperties();

    @Generated
    public OkHttpProperties() {
    }

    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    @Generated
    public Duration getPingInterval() {
        return this.pingInterval;
    }

    @Generated
    public CacheProperties getCache() {
        return this.cache;
    }

    @Generated
    public boolean isFollowSslRedirects() {
        return this.followSslRedirects;
    }

    @Generated
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Generated
    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    @Generated
    public ConnectionPoolProperties getConnectionPool() {
        return this.connectionPool;
    }

    @Generated
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Generated
    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    @Generated
    public void setPingInterval(Duration pingInterval) {
        this.pingInterval = pingInterval;
    }

    @Generated
    public void setCache(CacheProperties cache) {
        this.cache = cache;
    }

    @Generated
    public void setFollowSslRedirects(boolean followSslRedirects) {
        this.followSslRedirects = followSslRedirects;
    }

    @Generated
    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    @Generated
    public void setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkHttpProperties)) {
            return false;
        }
        OkHttpProperties other = (OkHttpProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFollowSslRedirects() != other.isFollowSslRedirects()) {
            return false;
        }
        if (this.isFollowRedirects() != other.isFollowRedirects()) {
            return false;
        }
        if (this.isRetryOnConnectionFailure() != other.isRetryOnConnectionFailure()) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Duration this$writeTimeout = this.getWriteTimeout();
        Duration other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        Duration this$pingInterval = this.getPingInterval();
        Duration other$pingInterval = other.getPingInterval();
        if (this$pingInterval == null ? other$pingInterval != null : !((Object)this$pingInterval).equals(other$pingInterval)) {
            return false;
        }
        CacheProperties this$cache = this.getCache();
        CacheProperties other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        ConnectionPoolProperties this$connectionPool = this.getConnectionPool();
        ConnectionPoolProperties other$connectionPool = other.getConnectionPool();
        return !(this$connectionPool == null ? other$connectionPool != null : !((Object)this$connectionPool).equals(other$connectionPool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OkHttpProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFollowSslRedirects() ? 79 : 97);
        result = result * 59 + (this.isFollowRedirects() ? 79 : 97);
        result = result * 59 + (this.isRetryOnConnectionFailure() ? 79 : 97);
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Duration $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        Duration $pingInterval = this.getPingInterval();
        result = result * 59 + ($pingInterval == null ? 43 : ((Object)$pingInterval).hashCode());
        CacheProperties $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        ConnectionPoolProperties $connectionPool = this.getConnectionPool();
        result = result * 59 + ($connectionPool == null ? 43 : ((Object)$connectionPool).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OkHttpProperties(connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", pingInterval=" + this.getPingInterval() + ", cache=" + this.getCache() + ", followSslRedirects=" + this.isFollowSslRedirects() + ", followRedirects=" + this.isFollowRedirects() + ", retryOnConnectionFailure=" + this.isRetryOnConnectionFailure() + ", connectionPool=" + this.getConnectionPool() + ")";
    }

    public static class CacheProperties {
        private boolean enabled;
        private DataSize maxSize = DataSize.ofMegabytes((long)10L);
        private File directory;

        @Generated
        public CacheProperties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public DataSize getMaxSize() {
            return this.maxSize;
        }

        @Generated
        public File getDirectory() {
            return this.directory;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMaxSize(DataSize maxSize) {
            this.maxSize = maxSize;
        }

        @Generated
        public void setDirectory(File directory) {
            this.directory = directory;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheProperties)) {
                return false;
            }
            CacheProperties other = (CacheProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            DataSize this$maxSize = this.getMaxSize();
            DataSize other$maxSize = other.getMaxSize();
            if (this$maxSize == null ? other$maxSize != null : !this$maxSize.equals(other$maxSize)) {
                return false;
            }
            File this$directory = this.getDirectory();
            File other$directory = other.getDirectory();
            return !(this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            DataSize $maxSize = this.getMaxSize();
            result = result * 59 + ($maxSize == null ? 43 : $maxSize.hashCode());
            File $directory = this.getDirectory();
            result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OkHttpProperties.CacheProperties(enabled=" + this.isEnabled() + ", maxSize=" + this.getMaxSize() + ", directory=" + this.getDirectory() + ")";
        }
    }

    public static class ConnectionPoolProperties {
        private int maxIdleConnections = 5;
        private Duration keepAliveDuration = Duration.ofMinutes(5L);

        @Generated
        public ConnectionPoolProperties() {
        }

        @Generated
        public int getMaxIdleConnections() {
            return this.maxIdleConnections;
        }

        @Generated
        public Duration getKeepAliveDuration() {
            return this.keepAliveDuration;
        }

        @Generated
        public void setMaxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
        }

        @Generated
        public void setKeepAliveDuration(Duration keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectionPoolProperties)) {
                return false;
            }
            ConnectionPoolProperties other = (ConnectionPoolProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxIdleConnections() != other.getMaxIdleConnections()) {
                return false;
            }
            Duration this$keepAliveDuration = this.getKeepAliveDuration();
            Duration other$keepAliveDuration = other.getKeepAliveDuration();
            return !(this$keepAliveDuration == null ? other$keepAliveDuration != null : !((Object)this$keepAliveDuration).equals(other$keepAliveDuration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConnectionPoolProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxIdleConnections();
            Duration $keepAliveDuration = this.getKeepAliveDuration();
            result = result * 59 + ($keepAliveDuration == null ? 43 : ((Object)$keepAliveDuration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OkHttpProperties.ConnectionPoolProperties(maxIdleConnections=" + this.getMaxIdleConnections() + ", keepAliveDuration=" + this.getKeepAliveDuration() + ")";
        }
    }
}

