/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.spring.okhttp.metrics;

import io.freefair.spring.okhttp.OkHttpProperties;
import io.freefair.spring.okhttp.metrics.OkHttpMetricsProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpConnectionPoolMetrics;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpMetricsEventListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;

@AutoConfiguration(after={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnBean(value={MeterRegistry.class})
@ConditionalOnClass(value={MeterRegistry.class, OkHttpMetricsEventListener.class, OkHttpClient.class})
@EnableConfigurationProperties(value={OkHttpMetricsProperties.class})
public class OkHttpMetricsAutoConfiguration {
    @Autowired
    private OkHttpMetricsProperties properties;

    @Bean
    @ConditionalOnProperty(value={"okhttp.metrics.enabled"}, matchIfMissing=true, havingValue="true")
    @ConditionalOnMissingBean
    public OkHttpMetricsEventListener okHttpMetricsEventListener(MeterRegistry meterRegistry) {
        Map<String, String> tags;
        OkHttpMetricsEventListener.Builder builder = OkHttpMetricsEventListener.builder((MeterRegistry)meterRegistry, (String)this.properties.getName()).includeHostTag(this.properties.isIncludeHostTag());
        List<String> requestTagKeys = this.properties.getRequestTagKeys();
        if (!CollectionUtils.isEmpty(requestTagKeys)) {
            builder = builder.requestTagKeys(requestTagKeys);
        }
        if (!CollectionUtils.isEmpty(tags = this.properties.getTags())) {
            builder = builder.tags(this.getTags(tags));
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnProperty(value={"okhttp.metrics.pool.enabled"}, matchIfMissing=true, havingValue="true")
    @ConditionalOnBean(value={ConnectionPool.class})
    @ConditionalOnMissingBean
    public OkHttpConnectionPoolMetrics okHttpConnectionPoolMetrics(ConnectionPool connectionPool, OkHttpProperties okHttpProperties) {
        OkHttpMetricsProperties.ConnectionPoolMetricsProperties poolProperties = this.properties.getPool();
        return new OkHttpConnectionPoolMetrics(connectionPool, poolProperties.getNamePrefix(), this.getTags(poolProperties.getTags()), Integer.valueOf(okHttpProperties.getConnectionPool().getMaxIdleConnections()));
    }

    private List<Tag> getTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
    }
}

