/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.spring.okhttp;

import io.freefair.spring.okhttp.ApplicationInterceptor;
import io.freefair.spring.okhttp.Configurer;
import io.freefair.spring.okhttp.NetworkInterceptor;
import io.freefair.spring.okhttp.OkHttpProperties;
import io.freefair.spring.okhttp.OkHttpRestTemplateAutoConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OkHttpClient.class})
@EnableConfigurationProperties(value={OkHttpProperties.class})
public class OkHttp3AutoConfiguration {
    @Autowired
    private OkHttpProperties okHttpProperties;
    @Autowired
    private ObjectProvider<Configurer<OkHttpClient.Builder>> configurers;
    @Autowired
    @ApplicationInterceptor
    private ObjectProvider<Interceptor> applicationInterceptors;
    @Autowired
    @NetworkInterceptor
    private ObjectProvider<Interceptor> networkInterceptors;

    @Bean
    @ConditionalOnMissingBean
    public OkHttpClient okHttp3Client(ObjectProvider<Cache> cache, ObjectProvider<CookieJar> cookieJar, ObjectProvider<Dns> dns, ConnectionPool connectionPool) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        cache.ifUnique(arg_0 -> ((OkHttpClient.Builder)builder).cache(arg_0));
        builder.connectTimeout(this.okHttpProperties.getConnectTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder.readTimeout(this.okHttpProperties.getReadTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder.writeTimeout(this.okHttpProperties.getWriteTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder.pingInterval(this.okHttpProperties.getPingInterval().toMillis(), TimeUnit.MILLISECONDS);
        cookieJar.ifUnique(arg_0 -> ((OkHttpClient.Builder)builder).cookieJar(arg_0));
        dns.ifUnique(arg_0 -> ((OkHttpClient.Builder)builder).dns(arg_0));
        builder.connectionPool(connectionPool);
        builder.followRedirects(this.okHttpProperties.isFollowRedirects());
        builder.followSslRedirects(this.okHttpProperties.isFollowSslRedirects());
        builder.retryOnConnectionFailure(this.okHttpProperties.isRetryOnConnectionFailure());
        this.applicationInterceptors.forEach(i -> builder.interceptors().add(i));
        this.networkInterceptors.forEach(i -> builder.networkInterceptors().add(i));
        this.configurers.forEach(configurer -> configurer.configure(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionPool okHttp3ConnectionPool() {
        int maxIdleConnections = this.okHttpProperties.getConnectionPool().getMaxIdleConnections();
        Duration keepAliveDuration = this.okHttpProperties.getConnectionPool().getKeepAliveDuration();
        return new ConnectionPool(maxIdleConnections, keepAliveDuration.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"okhttp.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public Cache okHttp3Cache() throws IOException {
        File directory = this.okHttpProperties.getCache().getDirectory();
        if (directory == null) {
            directory = Files.createTempDirectory("okhttp-cache", new FileAttribute[0]).toFile();
        }
        return new Cache(directory, this.okHttpProperties.getCache().getMaxSize().toBytes());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OkHttp3ClientHttpRequestFactory.class})
    @AutoConfigureBefore(value={OkHttpRestTemplateAutoConfiguration.class})
    @AutoConfigureAfter(value={OkHttp3AutoConfiguration.class})
    public static class RequestFactoryAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={OkHttp3ClientHttpRequestFactory.class})
        public OkHttp3ClientHttpRequestFactory okHttp3ClientHttpRequestFactory(OkHttpClient okHttpClient) {
            return new OkHttp3ClientHttpRequestFactory(okHttpClient);
        }
    }
}

