/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugin.codegenerator;

import io.freefair.gradle.codegenerator.api.Generator;
import io.freefair.gradle.codegenerator.api.ProjectContext;
import io.freefair.gradle.codegenerator.api.annotations.CodeGenerator;
import io.freefair.gradle.plugin.codegenerator.CodeGeneratorExecutor;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenerateCodeTask
extends DefaultTask {
    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getInputDir();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Input
    @Optional
    public abstract MapProperty<String, Object> getConfigurationValues();

    @Input
    public abstract Property<String> getSourceSet();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getCodeGeneratorClasspath();

    @TaskAction
    public void generate() {
        ScanResult scan = new ClassGraph().overrideClasspath((Iterable)this.getCodeGeneratorClasspath()).enableClassInfo().enableAnnotationInfo().scan();
        ClassInfoList classesWithAnnotation = scan.getClassesWithAnnotation(CodeGenerator.class.getCanonicalName());
        ClassInfoList classesImplementing = scan.getClassesImplementing(Generator.class.getCanonicalName());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Found {} with code generator annotation ({}): ", (Object)classesWithAnnotation.size(), (Object)CodeGenerator.class.getCanonicalName());
            this.getLogger().debug(classesWithAnnotation.stream().map(ClassInfo::getName).collect(Collectors.joining(",")));
            this.getLogger().debug("Found {} implementing {}: ", (Object)classesImplementing.size(), (Object)Generator.class.getCanonicalName());
            this.getLogger().debug(classesImplementing.stream().map(ClassInfo::getName).collect(Collectors.joining(",")));
        }
        ProjectContext context = new ProjectContext(this.getProjectLayout().getProjectDirectory().getAsFile(), (File)this.getInputDir().getAsFile().getOrElse((Object)this.getTemporaryDir()), (File)this.getOutputDir().getAsFile().get(), (Map)this.getConfigurationValues().getOrElse(Collections.emptyMap()), (String)this.getSourceSet().getOrElse((Object)"none"));
        WorkQueue workQueue = this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getCodeGeneratorClasspath()}));
        for (ClassInfo classInfo : classesWithAnnotation) {
            workQueue.submit(UnitOfWork.class, parameters -> {
                parameters.getClassName().set((Object)classInfo.getName());
                parameters.getProjectContext().set((Object)context);
            });
        }
    }

    static abstract class UnitOfWork
    implements WorkAction<Parameters> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(UnitOfWork.class);

        public void execute() {
            String className = (String)((Parameters)this.getParameters()).getClassName().get();
            log.info("Executing {} ...", (Object)className);
            new CodeGeneratorExecutor(Class.forName(className)).execute((ProjectContext)((Parameters)this.getParameters()).getProjectContext().get());
            log.debug("... Success");
        }

        @Inject
        @Generated
        public UnitOfWork() {
        }
    }

    static interface Parameters
    extends WorkParameters {
        public Property<String> getClassName();

        public Property<ProjectContext> getProjectContext();
    }
}

