/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugin.codegenerator;

import io.freefair.gradle.plugin.codegenerator.CodeGeneratorConfiguration;
import io.freefair.gradle.plugin.codegenerator.GenerateCodeTask;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class CodeGeneratorPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        CodeGeneratorConfiguration codeGenerator = (CodeGeneratorConfiguration)project.getExtensions().create("codeGenerator", CodeGeneratorConfiguration.class, new Object[]{project.getObjects()});
        Configuration codeGeneratorConfiguration = (Configuration)project.getConfigurations().create("codeGenerator");
        project.getPlugins().apply(JavaPlugin.class);
        JavaPluginExtension plugin = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        plugin.getSourceSets().all(sourceSet -> {
            String outputDir = "generated/sources/codeGenerator/java/" + sourceSet.getName();
            Provider outputDirFile = project.getLayout().getBuildDirectory().dir(outputDir);
            project.getLogger().debug("Using output dir {}", (Object)outputDir);
            File inputDir = new File(project.getProjectDir() + "/src/code-generator/" + sourceSet.getName());
            sourceSet.getJava().srcDir((Object)inputDir);
            sourceSet.getJava().srcDir((Object)outputDirFile);
            project.getLogger().debug("Using input dir {}", (Object)inputDir);
            String taskName = sourceSet.getTaskName("generate", "Code");
            TaskProvider generate = project.getTasks().register(taskName, GenerateCodeTask.class, s -> {
                s.setGroup("generate");
                s.getOutputDir().set(outputDirFile);
                if (inputDir.isDirectory()) {
                    s.getInputDir().set(inputDir);
                }
                s.getSourceSet().set((Object)sourceSet.getName());
                s.getCodeGeneratorClasspath().from(new Object[]{codeGeneratorConfiguration});
                s.getConfigurationValues().set(codeGenerator.getConfigurationValues());
                s.dependsOn(new Object[]{codeGeneratorConfiguration});
            });
            project.getTasks().named(sourceSet.getCompileJavaTaskName(), t -> t.dependsOn(new Object[]{generate}));
        });
    }
}

