/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.codegenerator.api;

import io.freefair.gradle.codegenerator.api.ProjectFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public class ProjectContext
implements Serializable {
    private File rootDir;
    private File inputDir;
    private File outputDir;
    private Map<String, Object> configurationValues;

    public String getNamespaceFromFile(File file) {
        String absolutePath = file.getAbsolutePath();
        if (absolutePath.startsWith(this.inputDir.getAbsolutePath())) {
            absolutePath = absolutePath.replace(this.inputDir.getAbsolutePath(), "");
        } else if (absolutePath.startsWith(this.outputDir.getAbsolutePath())) {
            absolutePath = absolutePath.replace(this.outputDir.getAbsolutePath(), "");
        }
        return absolutePath.substring(1).replace("/", ".");
    }

    public List<ProjectFile> getAllFiles() {
        return this.getAllFiles("", this.inputDir);
    }

    private List<ProjectFile> getAllFiles(String prefix, File directory) {
        File[] array;
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
        if (directory.isDirectory() && (array = directory.listFiles()) != null) {
            result.addAll(Arrays.stream(array).filter(File::isDirectory).flatMap(f -> this.getAllFiles(prefix + f.getName() + ".", (File)f).stream()).collect(Collectors.toList()));
            result.addAll(Arrays.stream(array).filter(File::isFile).map(f -> new ProjectFile(prefix, f.getName(), this)).collect(Collectors.toList()));
        }
        return result;
    }

    public byte[] readFileToByteArray(String namespace, String filename) throws IOException {
        return FileUtils.readFileToByteArray((File)this.buildFileFromParts(this.inputDir, namespace, filename));
    }

    public String readFile(String namespace, String filename) throws IOException {
        return this.readFile(namespace, filename, "UTF-8");
    }

    public String readFile(String namespace, String filename, String encoding) throws IOException {
        return FileUtils.readFileToString((File)this.buildFileFromParts(this.inputDir, namespace, filename), (String)encoding);
    }

    public void writeOutputFile(String namespace, String filename, String content) throws IOException {
        this.writeOutputFile(namespace, filename, content.getBytes());
    }

    public void writeOutputFile(String namespace, String filename, byte[] content) throws IOException {
        boolean mkdirs;
        File file = this.buildFileFromParts(this.outputDir, namespace, filename);
        boolean bl = mkdirs = file.getParentFile().exists() || file.getParentFile().mkdirs();
        if (!mkdirs) {
            throw new IOException("Cannot create directory " + file.getParent());
        }
        FileUtils.writeByteArrayToFile((File)file, (byte[])content);
    }

    private File buildFileFromParts(String namespace, String filename) {
        return new File(namespace.replace(".", "/"), filename);
    }

    private File buildFileFromParts(File root, String namespace, String filename) {
        return new File(root, this.buildFileFromParts(namespace, filename).getPath());
    }

    public boolean configurationExists(String key) {
        return this.configurationValues.containsKey(key);
    }

    public Object getConfigurationValue(String key) {
        return this.configurationValues.get(key);
    }

    public <T> T getConfigurationValueAs(String key, Class<T> clazz) {
        Object data = this.configurationValues.get(key);
        if (clazz.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        throw new RuntimeException("Could not transform value of type " + data.getClass().getCanonicalName() + " to " + clazz.getCanonicalName());
    }

    @Generated
    public File getRootDir() {
        return this.rootDir;
    }

    @Generated
    public File getInputDir() {
        return this.inputDir;
    }

    @Generated
    public File getOutputDir() {
        return this.outputDir;
    }

    @Generated
    void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    @Generated
    void setInputDir(File inputDir) {
        this.inputDir = inputDir;
    }

    @Generated
    void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Generated
    void setConfigurationValues(Map<String, Object> configurationValues) {
        this.configurationValues = configurationValues;
    }

    @Generated
    public ProjectContext(File rootDir, File inputDir, File outputDir, Map<String, Object> configurationValues) {
        this.rootDir = rootDir;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.configurationValues = configurationValues;
    }

    @Generated
    Map<String, Object> getConfigurationValues() {
        return this.configurationValues;
    }
}

