/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.api.role.access.v1;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.RoleAccessServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.exception.RoleAccessNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CreateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.FindRoleAccessWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.UpdateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.resources.RoleAccessResource;

@RestController
@Component
public class RoleAccessController
implements RoleAccessResource {
    private final RoleAccessServiceFacade roleAccessServiceFacade;

    @PostMapping(value={"/api/v1/role-accesses"}, produces={"application/json"})
    public SuccessApiResponse<RoleAccessResponse> create(@RequestBody CreateRoleAccessRequest request) {
        return SuccessApiResponse.of((Object)this.roleAccessServiceFacade.create(request));
    }

    @DeleteMapping(value={"/api/v1/role-accesses/{id}"}, produces={"application/json"})
    public OkApiResponse delete(@PathVariable String id) {
        this.roleAccessServiceFacade.delete(id);
        return OkApiResponse.of();
    }

    @GetMapping(value={"/api/v1/role-accesses/{id}"}, produces={"application/json"})
    public SuccessApiResponse<RoleAccessResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of((Object)((RoleAccessResponse)this.roleAccessServiceFacade.findById(id).orElseThrow(RoleAccessNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/role-accesses"}, produces={"application/json"})
    public SuccessApiResponse<SearchApiResponse<RoleAccessResponse>> find(@ModelAttribute FindRoleAccessWithFiltersRequest request) {
        SearchResult result = this.roleAccessServiceFacade.find(request);
        return SuccessApiResponse.of((Object)SearchApiResponse.withItemsAndCount((List)result.getItems(), (Long)result.getCount()));
    }

    @PutMapping(value={"/api/v1/role-accesses/{id}"}, produces={"application/json"})
    public SuccessApiResponse<RoleAccessResponse> update(@PathVariable String id, @RequestBody UpdateRoleAccessRequest request) {
        return SuccessApiResponse.of((Object)this.roleAccessServiceFacade.update(id, request));
    }

    public RoleAccessController(RoleAccessServiceFacade roleAccessServiceFacade) {
        this.roleAccessServiceFacade = roleAccessServiceFacade;
    }
}

