/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.tests.kafka.utils;

import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.utils.KafkaTestUtils;

public class KafkaTestConsumerUtils {
    public static <K, V> Consumer<K, V> buildStringSerializationConsumer(EmbeddedKafkaBroker embeddedKafka) {
        return KafkaTestConsumerUtils.buildConsumer(embeddedKafka, StringDeserializer.class, JsonDeserializer.class);
    }

    public static <K, V> Consumer<K, V> buildConsumer(EmbeddedKafkaBroker embeddedKafka, Class<? extends Deserializer<?>> keyDeserializer, Class<?> valueDeserializer) {
        Map consumerProps = KafkaTestUtils.consumerProps((String)("test-consumer-" + UUID.randomUUID().toString()), (String)"true", (EmbeddedKafkaBroker)embeddedKafka);
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("key.deserializer", keyDeserializer.getName());
        consumerProps.put("value.deserializer", valueDeserializer.getName());
        return KafkaTestConsumerUtils.buildConsumer(consumerProps);
    }

    private static <K, V> Consumer<K, V> buildConsumer(Map<String, Object> properties) {
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(properties);
        return consumerFactory.createConsumer();
    }
}

