/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.i18n.translator;

import io.foodtechlab.i18n.core.ExtendedLocale;
import io.foodtechlab.i18n.exception.IllegalInjectionTypeException;
import io.foodtechlab.i18n.translator.LocalizationI18NTranslator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;

public class RuLocalizationI18NTranslator
extends LocalizationI18NTranslator {
    private final Locale locale = ExtendedLocale.RUSSIA;

    public RuLocalizationI18NTranslator(MessageSource localizationSource) {
        super(localizationSource);
    }

    @Override
    public boolean isRightTranslator(Locale locale) {
        if (locale == null) {
            return false;
        }
        return "ru".equals(locale.getLanguage());
    }

    @Override
    public String translate(String code) {
        return this.getText(code);
    }

    @Override
    public <T> String translate(String code, Map<String, T> injections) {
        String result = this.getText(code);
        if (this.hasNumberCase(code)) {
            List<String> caseFields = this.getCaseFields(code);
            for (Map.Entry<String, T> entry : injections.entrySet()) {
                if (caseFields.contains(entry.getKey())) {
                    result = result.replace(this.toCaseKey(entry.getKey()), this.getCaseByNumber(code, entry.getKey(), entry.getValue().toString()));
                }
                result = result.replace(this.toInjectionKey(entry.getKey()), entry.getValue().toString());
            }
        } else {
            for (Map.Entry<String, T> entry : injections.entrySet()) {
                result = result.replace(this.toInjectionKey(entry.getKey()), entry.getValue().toString());
            }
        }
        return result;
    }

    private String getCaseByNumber(String code, String key, String value) {
        long number;
        try {
            number = Math.abs(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalInjectionTypeException(key);
        }
        List<String> caseVariations = this.getCaseVariation(code, key);
        if (caseVariations.size() < 3) {
            return "";
        }
        if (number % 10L == 1L && number % 100L != 11L) {
            return caseVariations.get(0);
        }
        if (number % 10L >= 2L && number % 10L <= 4L && (number % 100L < 10L || number % 100L >= 20L)) {
            return caseVariations.get(1);
        }
        return caseVariations.get(2);
    }

    private List<String> getCaseVariation(String code, String key) {
        String caseVariation = this.getProperty(String.format("%s.%s", code, key));
        if (caseVariation == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(caseVariation.split(","));
    }

    private String toCaseKey(String key) {
        return String.format("{%s:case}", key);
    }

    private List<String> getCaseFields(String code) {
        return Arrays.asList(this.getProperty(code + ".caseFields").split(","));
    }

    protected boolean hasNumberCase(String code) {
        return "true".equals(this.getProperty(code + ".hasNumberCase"));
    }

    @Override
    public String getText(String code) {
        return this.getProperty(code + ".text");
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

