/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.i18n.translator;

import io.foodtechlab.i18n.I18NTranslator;
import org.springframework.context.MessageSource;

public abstract class LocalizationI18NTranslator
implements I18NTranslator {
    private final MessageSource localizationSource;

    public LocalizationI18NTranslator(MessageSource localizationSource) {
        this.localizationSource = localizationSource;
    }

    protected String getText(String code) {
        return this.getProperty(code + ".text");
    }

    protected String toInjectionKey(String key) {
        return String.format("{%s}", key);
    }

    protected String getProperty(String code) {
        try {
            return this.localizationSource.getMessage(code, null, this.getLocale());
        }
        catch (Exception e) {
            return null;
        }
    }
}

