/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.i18n.qualifier;

import io.foodtechlab.i18n.I18NTranslator;
import io.foodtechlab.i18n.exception.DefaultTranslatorNotSetException;
import io.foodtechlab.i18n.exception.NotUniqueTranslatorException;
import io.foodtechlab.i18n.exception.TranslatorHasInvalidLocaleException;
import io.foodtechlab.i18n.exception.TranslatorListAreEmptyException;
import io.foodtechlab.i18n.qualifier.I18NTranslatorQualifier;
import java.util.ArrayList;
import java.util.List;

public class I18NTranslatorQualifierBuilder {
    private final List<I18NTranslator> translators = new ArrayList<I18NTranslator>();
    private I18NTranslator defaultTranslator;

    public static I18NTranslatorQualifierBuilder init() {
        return new I18NTranslatorQualifierBuilder();
    }

    private void validate(I18NTranslator translator) {
        if (translator.getLocale() == null) {
            throw new TranslatorHasInvalidLocaleException();
        }
    }

    public I18NTranslatorQualifierBuilder add(I18NTranslator translator) {
        this.validate(translator);
        if (this.translators.stream().anyMatch(addedTranslator -> addedTranslator.getLocale().equals(translator.getLocale()))) {
            throw new NotUniqueTranslatorException();
        }
        this.translators.add(translator);
        return this;
    }

    public I18NTranslatorQualifierBuilder setDefault(I18NTranslator translator) {
        this.validate(translator);
        this.defaultTranslator = translator;
        return this;
    }

    public I18NTranslatorQualifier build() {
        if (this.translators.isEmpty()) {
            throw new TranslatorListAreEmptyException();
        }
        if (this.defaultTranslator == null) {
            throw new DefaultTranslatorNotSetException();
        }
        return new I18NTranslatorQualifier(this.translators, this.defaultTranslator);
    }
}

