/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exception.converter.rcore.domain.exceptions;

import com.rcore.domain.commons.exception.BadRequestDomainException;
import com.rcore.domain.commons.exception.DomainException;
import java.util.List;
import java.util.stream.Collectors;

public class HandledRCoreDomainException
extends RuntimeException {
    private final List<RCoreError> errors;

    public HandledRCoreDomainException(List<RCoreError> errors) {
        super("Unhandled integration rcore exceptions: " + errors.stream().map(Object::toString).collect(Collectors.joining("\n")));
        this.errors = errors;
    }

    public DomainException toDomainException() {
        return new BadRequestDomainException(this.errors.stream().map(RCoreError::toRCoreError).collect(Collectors.toList()));
    }

    public List<RCoreError> getErrors() {
        return this.errors;
    }

    public static final class PresentationData {
        private final String title;
        private final String message;

        public static PresentationDataBuilder builder() {
            return new PresentationDataBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public String getMessage() {
            return this.message;
        }

        public PresentationData(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public String toString() {
            return "HandledRCoreDomainException.PresentationData(title=" + this.getTitle() + ", message=" + this.getMessage() + ")";
        }

        public static class PresentationDataBuilder {
            private String title;
            private String message;

            PresentationDataBuilder() {
            }

            public PresentationDataBuilder title(String title) {
                this.title = title;
                return this;
            }

            public PresentationDataBuilder message(String message) {
                this.message = message;
                return this;
            }

            public PresentationData build() {
                return new PresentationData(this.title, this.message);
            }

            public String toString() {
                return "HandledRCoreDomainException.PresentationData.PresentationDataBuilder(title=" + this.title + ", message=" + this.message + ")";
            }
        }
    }

    public static final class RCoreError {
        private final String domain;
        private final String reason;
        private final String details;
        private final PresentationData presentationData;

        public DomainException.Error toRCoreError() {
            return new DomainException.Error(this.domain, this.reason, this.details);
        }

        public static RCoreErrorBuilder builder() {
            return new RCoreErrorBuilder();
        }

        public String getDomain() {
            return this.domain;
        }

        public String getReason() {
            return this.reason;
        }

        public String getDetails() {
            return this.details;
        }

        public PresentationData getPresentationData() {
            return this.presentationData;
        }

        public RCoreError(String domain, String reason, String details, PresentationData presentationData) {
            this.domain = domain;
            this.reason = reason;
            this.details = details;
            this.presentationData = presentationData;
        }

        public static class RCoreErrorBuilder {
            private String domain;
            private String reason;
            private String details;
            private PresentationData presentationData;

            RCoreErrorBuilder() {
            }

            public RCoreErrorBuilder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public RCoreErrorBuilder reason(String reason) {
                this.reason = reason;
                return this;
            }

            public RCoreErrorBuilder details(String details) {
                this.details = details;
                return this;
            }

            public RCoreErrorBuilder presentationData(PresentationData presentationData) {
                this.presentationData = presentationData;
                return this;
            }

            public RCoreError build() {
                return new RCoreError(this.domain, this.reason, this.details, this.presentationData);
            }

            public String toString() {
                return "HandledRCoreDomainException.RCoreError.RCoreErrorBuilder(domain=" + this.domain + ", reason=" + this.reason + ", details=" + this.details + ", presentationData=" + this.presentationData + ")";
            }
        }
    }
}

