/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exception.converter.rcore.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rcore.domain.security.exceptions.AuthorizationErrorReason;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import io.foodtechlab.exception.converter.core.CheckedExceptionService;
import io.foodtechlab.exception.converter.rcore.domain.exceptions.HandledRCoreDomainException;
import io.foodtechlab.exception.converter.rcore.resource.CheckedExceptionResponse;
import io.foodtechlab.exception.converter.rcore.resource.mappers.HandledRCoreDomainMapper;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;

@Component
public class CheckedExceptionRCoreErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(CheckedExceptionRCoreErrorDecoder.class);
    private static final List<String> reasonsForRetry = Arrays.asList(AuthorizationErrorReason.ACCESS_TOKEN_EXPIRED.name(), AuthorizationErrorReason.ACCESS_TOKEN_INACTIVATED.name(), AuthorizationErrorReason.ACCESS_TOKEN_REFRESHED.name(), AuthorizationErrorReason.ACCESS_TOKEN_NOT_EXIST.name(), AuthorizationErrorReason.ACCESS_TOKEN_MODIFIED.name(), AuthorizationErrorReason.ACCESS_TOKEN_MALFORMED.name());
    private final CheckedExceptionService checkedExceptionService;
    private final AccessTokenService accessTokenService;
    private final ObjectMapper objectMapper;
    private final HandledRCoreDomainMapper handledRCoreDomainMapper;

    public Exception decode(String methodKey, Response response) {
        String raw = IOUtils.toString((InputStream)response.body().asInputStream(), (Charset)StandardCharsets.UTF_8);
        response.close();
        JsonNode node = this.objectMapper.readTree(raw);
        if (node.has("errors")) {
            String reason;
            ErrorApiResponse errorResponse = (ErrorApiResponse)this.objectMapper.convertValue((Object)node, (TypeReference)new TypeReference<ErrorApiResponse<Error>>(){});
            if ((response.status() == 401 || response.status() == 403) && !errorResponse.getErrors().isEmpty() && reasonsForRetry.contains(reason = ((Error)errorResponse.getErrors().get(0)).getReason())) {
                this.accessTokenService.clearToken(response.request().url());
                throw new RetryableException(response.status(), response.reason(), response.request().httpMethod(), null, response.request());
            }
            return this.decode((ErrorApiResponse<Error>)errorResponse, raw);
        }
        if (node.has("domain")) {
            CheckedExceptionResponse checkedResponse = (CheckedExceptionResponse)this.objectMapper.convertValue((Object)node, CheckedExceptionResponse.class);
            return this.checkedExceptionService.parse(checkedResponse);
        }
        log.error("Unknown exception\n{}", (Object)raw);
        return new RuntimeException("Unknown exception: " + raw);
    }

    public Exception decode(ErrorApiResponse<Error> errorApiResponse, String raw) {
        HandledRCoreDomainException exception = new HandledRCoreDomainException(errorApiResponse.getErrors().stream().map(arg_0 -> ((HandledRCoreDomainMapper)this.handledRCoreDomainMapper).inverseMap(arg_0)).collect(Collectors.toList()));
        log.error("Handled rcore exception\n{}", (Object)raw);
        return exception;
    }

    public CheckedExceptionRCoreErrorDecoder(CheckedExceptionService checkedExceptionService, AccessTokenService accessTokenService, ObjectMapper objectMapper, HandledRCoreDomainMapper handledRCoreDomainMapper) {
        this.checkedExceptionService = checkedExceptionService;
        this.accessTokenService = accessTokenService;
        this.objectMapper = objectMapper;
        this.handledRCoreDomainMapper = handledRCoreDomainMapper;
    }
}

