/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exception.converter.handler;

import io.foodtechlab.exception.converter.core.CheckedExceptionService;
import io.foodtechlab.exception.converter.domain.CheckedDomainException;
import io.foodtechlab.exception.converter.rcore.resource.CheckedExceptionResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0)
public class CheckedExceptionHandler {
    private static final Logger log = LogManager.getLogger(CheckedExceptionHandler.class);
    private final CheckedExceptionService checkedExceptionService;

    @ExceptionHandler(value={CheckedDomainException.class})
    public ResponseEntity<CheckedExceptionResponse> checkedExceptionResponse(CheckedDomainException exception) {
        CheckedExceptionResponse response = this.checkedExceptionService.convert(exception);
        log.info("Checked Exception thrown" + exception.toString() + " catch");
        return ResponseEntity.badRequest().body((Object)response);
    }

    public CheckedExceptionHandler(CheckedExceptionService checkedExceptionService) {
        this.checkedExceptionService = checkedExceptionService;
    }
}

