/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.exception.converter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.foodtechlab.exception.converter.core.CheckedExceptionApiConverter;
import io.foodtechlab.exception.converter.domain.CheckedDomainException;
import io.foodtechlab.exception.converter.domain.UnknownCheckedDomainException;
import io.foodtechlab.exception.converter.rcore.resource.CheckedExceptionResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class CheckedExceptionService {
    private static final Logger log = LogManager.getLogger(CheckedExceptionService.class);
    private final Map<String, Collection<CheckedExceptionApiConverter<?, ?>>> mappers;
    private final ObjectMapper objectMapper;

    public CheckedExceptionService(Collection<CheckedExceptionApiConverter<?, ?>> mappers, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.mappers = mappers.stream().collect(Collectors.groupingBy(CheckedExceptionApiConverter::getDomain));
    }

    public CheckedExceptionApiConverter<?, ?> findConverter(String domain, String reason) {
        return ((Collection)this.mappers.getOrDefault(domain, Collections.emptySet())).stream().filter(m -> m.getReason().equals(reason)).findFirst().orElse(null);
    }

    private UnknownCheckedDomainException createUnknownDomainException(CheckedExceptionResponse response) {
        return new UnknownCheckedDomainException(response.getDomain(), response.getReason(), response.getDetails());
    }

    private CheckedExceptionResponse createUnknownResponse(CheckedDomainException exception) {
        return CheckedExceptionResponse.builder().details(exception.getDetails()).domain(exception.getDomain()).reason(exception.getReason()).build();
    }

    public CheckedDomainException parse(CheckedExceptionResponse response) {
        CheckedExceptionApiConverter<?, ?> exceptionConverter = this.findConverter(response.getDomain(), response.getReason());
        if (exceptionConverter == null) {
            return this.createUnknownDomainException(response);
        }
        try {
            return this._parse(exceptionConverter, response.getData());
        }
        catch (Exception exception) {
            log.info("Fail parse " + response);
            exception.printStackTrace();
            return this.createUnknownDomainException(response);
        }
    }

    public CheckedExceptionResponse convert(CheckedDomainException exception) {
        CheckedExceptionApiConverter<?, ?> converter = this.findConverter(exception.getDomain(), exception.getReason());
        if (converter == null) {
            return this.createUnknownResponse(exception);
        }
        try {
            return this._convert(converter, exception);
        }
        catch (Exception ex) {
            log.warn("Failing convert " + exception.getClass().getName() + " to response");
            ex.printStackTrace();
            return this.createUnknownResponse(exception);
        }
    }

    private <E extends CheckedDomainException, D> CheckedExceptionResponse _convert(CheckedExceptionApiConverter<?, ?> converter, E exception) {
        Object data = converter.writeResponse(exception);
        Map convertedData = data != null ? (Map)this.objectMapper.convertValue(data, Map.class) : null;
        return CheckedExceptionResponse.builder().reason(exception.getReason()).domain(exception.getDomain()).details(exception.getDetails()).data(convertedData).build();
    }

    private <E extends CheckedDomainException, D> E _parse(CheckedExceptionApiConverter<E, D> exceptionConverter, Map<String, Object> map) {
        Object data = map == null ? null : this.objectMapper.convertValue(map, exceptionConverter.getDataType());
        return exceptionConverter.readResponse(data);
    }
}

